/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.pojo;

import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DicomMailAddress")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DicomMailAddress
extends DatabaseBaseData {
    private static final long serialVersionUID = -480330302857294512L;
    public static final String TABLE_NAME = "DicomMailAddress";
    public static final String CONNECTION_ID = "connectionID";
    public static final String MAIL_ADDRESS = "mailAddress";
    public static final String CERTIFICATE_FORMAT = "certificateFormat";
    public static final String CERTIFICATE_ID = "certificateID";
    public static final String ENABLED = "enabled";
    public static final String DELETED = "deleted";
    public static final String LAST_UPDATE_DATE = "lastUpdateDate";
    public static final String LAST_UPDATE_FROM = "lastUpdateFrom";
    public static final String LAST_UPDATE_REVISION_SYSTEM_ID = "lastUpdateRevisionSystemID";
    public static final String LAST_UPDATE_REVISION_NUMBER = "lastUpdateRevisionNumber";
    public static final List<String> COLUMN_NAMES = new CopyOnWriteArrayList<String>();

    public DicomMailAddress() {
        this.setEnabled(true);
        this.setDeleted(false);
    }

    public DicomMailAddress(DicomMailAddress dicomMailAddress) {
        super(dicomMailAddress);
    }

    public void setConnectionID(String string) {
        this.setValue(CONNECTION_ID, string);
    }

    public void setConnectionIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 36) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailAddress.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field connectionID; limit = 36");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailAddress.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null connectionID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        this.setValue(CONNECTION_ID, string);
    }

    public String getConnectionID() {
        return this.getStringValue(CONNECTION_ID);
    }

    public void setMailAddress(String string) {
        this.setValue(MAIL_ADDRESS, string);
    }

    public void setMailAddressWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailAddress.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field mailAddress; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailAddress.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null mailAddress");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        this.setValue(MAIL_ADDRESS, string);
    }

    public String getMailAddress() {
        return this.getStringValue(MAIL_ADDRESS);
    }

    public void setCertificateFormat(int n) {
        this.setValue(CERTIFICATE_FORMAT, n);
    }

    public int getCertificateFormat() {
        return this.getIntegerValue(CERTIFICATE_FORMAT);
    }

    public void setCertificateID(String string) {
        this.setValue(CERTIFICATE_ID, string);
    }

    public void setCertificateIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailAddress.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field certificateID; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailAddress.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null certificateID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        this.setValue(CERTIFICATE_ID, string);
    }

    public String getCertificateID() {
        return this.getStringValue(CERTIFICATE_ID);
    }

    public void setEnabled(boolean bl) {
        this.setValue(ENABLED, bl);
    }

    public boolean isEnabled() {
        return this.getBooleanValue(ENABLED, true);
    }

    public void setDeleted(boolean bl) {
        this.setValue(DELETED, bl);
    }

    public boolean isDeleted() {
        return this.getBooleanValue(DELETED, false);
    }

    public void setLastUpdateDate(long l) {
        this.setValue(LAST_UPDATE_DATE, l);
    }

    public void setLastUpdateDateAsDate(Date date) {
        this.setTimestampValueAsDate(LAST_UPDATE_DATE, date);
    }

    public long getLastUpdateDate() {
        return this.getTimestampValue(LAST_UPDATE_DATE);
    }

    public Date getLastUpdateDateAsDate() {
        return this.getTimestampValueAsDate(LAST_UPDATE_DATE);
    }

    public void setLastUpdateFrom(String string) {
        this.setValue(LAST_UPDATE_FROM, string);
    }

    public void setLastUpdateFromWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailAddress.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field lastUpdateFrom; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailAddress.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null lastUpdateFrom");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        this.setValue(LAST_UPDATE_FROM, string);
    }

    public String getLastUpdateFrom() {
        return this.getStringValue(LAST_UPDATE_FROM);
    }

    public void setLastUpdateRevisionSystemID(String string) {
        this.setValue(LAST_UPDATE_REVISION_SYSTEM_ID, string);
    }

    public void setLastUpdateRevisionSystemIDWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 64) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailAddress.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field lastUpdateRevisionSystemID; limit = 64");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailAddress.a(illegalArgumentException);
            }
        }
        this.setValue(LAST_UPDATE_REVISION_SYSTEM_ID, string);
    }

    public String getLastUpdateRevisionSystemID() {
        return this.getStringValue(LAST_UPDATE_REVISION_SYSTEM_ID);
    }

    public void setLastUpdateRevisionNumber(long l) {
        this.setValue(LAST_UPDATE_REVISION_NUMBER, l);
    }

    public long getLastUpdateRevisionNumber() {
        return this.getLongValue(LAST_UPDATE_REVISION_NUMBER);
    }

    public String getCaseSensitiveName(String string) {
        for (String string2 : COLUMN_NAMES) {
            try {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailAddress.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean isModified(DicomMailAddress dicomMailAddress) {
        try {
            if (dicomMailAddress == null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getConnectionID(), dicomMailAddress.getConnectionID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getMailAddress(), dicomMailAddress.getMailAddress())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (this.getCertificateFormat() != dicomMailAddress.getCertificateFormat()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getCertificateID(), dicomMailAddress.getCertificateID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (this.isEnabled() != dicomMailAddress.isEnabled()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (this.isDeleted() != dicomMailAddress.isDeleted()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!DicomMailAddress.timestampValueEquals(this.getLastUpdateDate(), dicomMailAddress.getLastUpdateDate())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getLastUpdateFrom(), dicomMailAddress.getLastUpdateFrom())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getLastUpdateRevisionSystemID(), dicomMailAddress.getLastUpdateRevisionSystemID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (this.getLastUpdateRevisionNumber() != dicomMailAddress.getLastUpdateRevisionNumber()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3 = 31;
        int n4 = 1;
        String string = this.getConnectionID();
        try {
            n2 = 31 * n4;
            n = string == null ? 0 : string.hashCode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        n4 = n2 + n;
        return n4;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof DicomMailAddress)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        DicomMailAddress dicomMailAddress = (DicomMailAddress)object;
        try {
            if (this.getConnectionID() == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        try {
            if (!this.getConnectionID().equals(dicomMailAddress.getConnectionID())) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailAddress.a(illegalArgumentException);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DicomMailAddress\n");
        for (String string : COLUMN_NAMES) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this.getValue(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        COLUMN_NAMES.add(CONNECTION_ID);
        COLUMN_NAMES.add(MAIL_ADDRESS);
        COLUMN_NAMES.add(CERTIFICATE_FORMAT);
        COLUMN_NAMES.add(CERTIFICATE_ID);
        COLUMN_NAMES.add(ENABLED);
        COLUMN_NAMES.add(DELETED);
        COLUMN_NAMES.add(LAST_UPDATE_DATE);
        COLUMN_NAMES.add(LAST_UPDATE_FROM);
        COLUMN_NAMES.add(LAST_UPDATE_REVISION_SYSTEM_ID);
        COLUMN_NAMES.add(LAST_UPDATE_REVISION_NUMBER);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

