/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.pojo;

import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DVNonDicomData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DVNonDicomData
extends DatabaseBaseData {
    private static final long serialVersionUID = -3380627025469397662L;
    public static final String TABLE_NAME = "DVNonDicomData";
    public static final String JIVE_NON_DICOM_DATA_ID = "jiveNonDicomDataID";
    public static final String JIVE_STUDY_DATA_ID = "jiveStudyDataID";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_SIZE = "fileSize";
    public static final String ORIGIN_FILE_NAME = "originFileName";
    public static final String ADDRESSES_TO = "addressesTo";
    public static final String ADDRESSES_FROM = "addressesFrom";
    public static final String DATE_SEND = "dateSend";
    public static final String DATE_RECEIVED = "dateReceived";
    public static final List<String> COLUMN_NAMES = new CopyOnWriteArrayList<String>();

    public DVNonDicomData() {
    }

    public DVNonDicomData(DVNonDicomData dVNonDicomData) {
        super(dVNonDicomData);
    }

    public void setJiveNonDicomDataID(long l) {
        this.setValue(JIVE_NON_DICOM_DATA_ID, l);
    }

    public long getJiveNonDicomDataID() {
        return this.getLongValue(JIVE_NON_DICOM_DATA_ID);
    }

    public void setJiveStudyDataID(long l) {
        this.setValue(JIVE_STUDY_DATA_ID, l);
    }

    public long getJiveStudyDataID() {
        return this.getLongValue(JIVE_STUDY_DATA_ID);
    }

    public void setFileName(String string) {
        this.setValue(FILE_NAME, string);
    }

    public void setFileNameWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DVNonDicomData.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field fileName; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DVNonDicomData.a(illegalArgumentException);
            }
        }
        this.setValue(FILE_NAME, string);
    }

    public String getFileName() {
        return this.getStringValue(FILE_NAME);
    }

    public void setFileSize(long l) {
        this.setValue(FILE_SIZE, l);
    }

    public long getFileSize() {
        return this.getLongValue(FILE_SIZE);
    }

    public void setOriginFileName(String string) {
        this.setValue(ORIGIN_FILE_NAME, string);
    }

    public void setOriginFileNameWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DVNonDicomData.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field originFileName; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DVNonDicomData.a(illegalArgumentException);
            }
        }
        this.setValue(ORIGIN_FILE_NAME, string);
    }

    public String getOriginFileName() {
        return this.getStringValue(ORIGIN_FILE_NAME);
    }

    public void setAddressesTo(String string) {
        this.setValue(ADDRESSES_TO, string);
    }

    public void setAddressesToWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DVNonDicomData.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field addressesTo; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DVNonDicomData.a(illegalArgumentException);
            }
        }
        this.setValue(ADDRESSES_TO, string);
    }

    public String getAddressesTo() {
        return this.getStringValue(ADDRESSES_TO);
    }

    public void setAddressesFrom(String string) {
        this.setValue(ADDRESSES_FROM, string);
    }

    public void setAddressesFromWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DVNonDicomData.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field addressesFrom; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DVNonDicomData.a(illegalArgumentException);
            }
        }
        this.setValue(ADDRESSES_FROM, string);
    }

    public String getAddressesFrom() {
        return this.getStringValue(ADDRESSES_FROM);
    }

    public void setDateSend(long l) {
        this.setValue(DATE_SEND, l);
    }

    public void setDateSendAsDate(Date date) {
        this.setTimestampValueAsDate(DATE_SEND, date);
    }

    public long getDateSend() {
        return this.getTimestampValue(DATE_SEND);
    }

    public Date getDateSendAsDate() {
        return this.getTimestampValueAsDate(DATE_SEND);
    }

    public void setDateReceived(long l) {
        this.setValue(DATE_RECEIVED, l);
    }

    public void setDateReceivedAsDate(Date date) {
        this.setTimestampValueAsDate(DATE_RECEIVED, date);
    }

    public long getDateReceived() {
        return this.getTimestampValue(DATE_RECEIVED);
    }

    public Date getDateReceivedAsDate() {
        return this.getTimestampValueAsDate(DATE_RECEIVED);
    }

    public String getCaseSensitiveName(String string) {
        for (String string2 : COLUMN_NAMES) {
            try {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DVNonDicomData.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean isModified(DVNonDicomData dVNonDicomData) {
        try {
            if (dVNonDicomData == null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (this.getJiveNonDicomDataID() != dVNonDicomData.getJiveNonDicomDataID()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (this.getJiveStudyDataID() != dVNonDicomData.getJiveStudyDataID()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getFileName(), dVNonDicomData.getFileName())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (this.getFileSize() != dVNonDicomData.getFileSize()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getOriginFileName(), dVNonDicomData.getOriginFileName())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getAddressesTo(), dVNonDicomData.getAddressesTo())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getAddressesFrom(), dVNonDicomData.getAddressesFrom())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!DVNonDicomData.timestampValueEquals(this.getDateSend(), dVNonDicomData.getDateSend())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!DVNonDicomData.timestampValueEquals(this.getDateReceived(), dVNonDicomData.getDateReceived())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = this.getJiveNonDicomDataID();
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof DVNonDicomData)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        DVNonDicomData dVNonDicomData = (DVNonDicomData)object;
        try {
            if (this.getJiveNonDicomDataID() == 0L) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        try {
            if (this.getJiveNonDicomDataID() != dVNonDicomData.getJiveNonDicomDataID()) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DVNonDicomData.a(illegalArgumentException);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DVNonDicomData\n");
        for (String string : COLUMN_NAMES) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this.getValue(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        COLUMN_NAMES.add(JIVE_NON_DICOM_DATA_ID);
        COLUMN_NAMES.add(JIVE_STUDY_DATA_ID);
        COLUMN_NAMES.add(FILE_NAME);
        COLUMN_NAMES.add(FILE_SIZE);
        COLUMN_NAMES.add(ORIGIN_FILE_NAME);
        COLUMN_NAMES.add(ADDRESSES_TO);
        COLUMN_NAMES.add(ADDRESSES_FROM);
        COLUMN_NAMES.add(DATE_SEND);
        COLUMN_NAMES.add(DATE_RECEIVED);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

