/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data;

import com.visustt.tools.lang.StringTool;
import java.util.HashMap;
import java.util.Map;

public enum TransmitInformationFields {
    SERVICE,
    PORT,
    HOST,
    STATUS,
    TRANSFERSYNTAX,
    CALLINGAE,
    CALLEDAE,
    SOPCLASSUID,
    RECEIVEDATEEND,
    RECEIVEDATESTART,
    MODALITYNAME,
    OBSERVERNAME,
    IMAGEORDERVALUE,
    FREE1STUDY,
    FREE2STUDY,
    FREE3STUDY,
    FREE4STUDY,
    FREE5STUDY,
    FREE6STUDY,
    FREE7STUDY,
    FREE8STUDY,
    FREE9STUDY,
    FREE1SERIES,
    FREE2SERIES,
    FREE3SERIES,
    SERIESARCHIVEFLAG,
    VERIFICATIONFLAG,
    VERIFICATIONNAME,
    VERIFICATIONTYPE,
    MAILADDRESSFROM,
    MAILADDRESSTO,
    MAILRECEPTIONSTATUS,
    MAILPARTICIPANTFROM,
    MAILPARTICIPANTTO,
    JIVETENANTID,
    MAILADDRESSTOSENDJOB,
    MAILADDRESSFROMSENDJOB,
    SVS_LASTUPDATE,
    SVS_UPDATEORIGINATOR,
    SVS_MANUALUPDATE;

    private static Map<String, String> DB_FIELD_NAMES;

    public static boolean isValid(String string) {
        if (string != null) {
            for (TransmitInformationFields transmitInformationFields : TransmitInformationFields.values()) {
                if (!transmitInformationFields.toString().equals(string)) continue;
                return true;
            }
            if (string.matches("FREE\\d{2}STUDY")) {
                return true;
            }
        }
        return false;
    }

    public static String getMatchingDatabaseFieldName(String string) {
        if (string != null) {
            if (DB_FIELD_NAMES.containsKey(string)) {
                return DB_FIELD_NAMES.get(string);
            }
            if (string.matches("FREE\\d{2}STUDY")) {
                return StringTool.cutRight(string, 5).toLowerCase();
            }
        }
        return null;
    }

    static {
        DB_FIELD_NAMES = new HashMap<String, String>();
        DB_FIELD_NAMES.put(PORT.name(), "port");
        DB_FIELD_NAMES.put(HOST.name(), "host");
        DB_FIELD_NAMES.put(STATUS.name(), "status");
        DB_FIELD_NAMES.put(TRANSFERSYNTAX.name(), "transferSyntax");
        DB_FIELD_NAMES.put(CALLINGAE.name(), "callingAE");
        DB_FIELD_NAMES.put(CALLEDAE.name(), "calledAE");
        DB_FIELD_NAMES.put(SOPCLASSUID.name(), "sopClassUID");
        DB_FIELD_NAMES.put(RECEIVEDATEEND.name(), "receiveDateEnd");
        DB_FIELD_NAMES.put(RECEIVEDATESTART.name(), "receiveDateStart");
        DB_FIELD_NAMES.put(MODALITYNAME.name(), "modalityName");
        DB_FIELD_NAMES.put(OBSERVERNAME.name(), "observerName");
        DB_FIELD_NAMES.put(IMAGEORDERVALUE.name(), "imageOrderValue");
        DB_FIELD_NAMES.put(FREE1STUDY.name(), "free1");
        DB_FIELD_NAMES.put(FREE2STUDY.name(), "free2");
        DB_FIELD_NAMES.put(FREE3STUDY.name(), "free3");
        DB_FIELD_NAMES.put(FREE4STUDY.name(), "free4");
        DB_FIELD_NAMES.put(FREE5STUDY.name(), "free5");
        DB_FIELD_NAMES.put(FREE6STUDY.name(), "free6");
        DB_FIELD_NAMES.put(FREE7STUDY.name(), "free7");
        DB_FIELD_NAMES.put(FREE8STUDY.name(), "free8");
        DB_FIELD_NAMES.put(FREE9STUDY.name(), "free9");
        DB_FIELD_NAMES.put(FREE1SERIES.name(), "freeSeries1");
        DB_FIELD_NAMES.put(FREE2SERIES.name(), "freeSeries2");
        DB_FIELD_NAMES.put(FREE3SERIES.name(), "freeSeries3");
        DB_FIELD_NAMES.put(SERIESARCHIVEFLAG.name(), "archiveFlagSeries");
        DB_FIELD_NAMES.put(VERIFICATIONFLAG.name(), "verificationFlag");
        DB_FIELD_NAMES.put(VERIFICATIONNAME.name(), "verificationName");
        DB_FIELD_NAMES.put(MAILADDRESSFROM.name(), "mailAddressFrom");
        DB_FIELD_NAMES.put(MAILADDRESSTO.name(), "mailAddressTo");
        DB_FIELD_NAMES.put(MAILRECEPTIONSTATUS.name(), "mailReceptionStatus");
        DB_FIELD_NAMES.put(MAILPARTICIPANTFROM.name(), "mailParticipantsFrom");
        DB_FIELD_NAMES.put(MAILPARTICIPANTTO.name(), "mailParticipantsTo");
        DB_FIELD_NAMES.put(JIVETENANTID.name(), "jiveTenantID");
        DB_FIELD_NAMES.put(SVS_LASTUPDATE.name(), "svs_lastUpdate");
        DB_FIELD_NAMES.put(SVS_UPDATEORIGINATOR.name(), "svs_updateOriginator");
        DB_FIELD_NAMES.put(SVS_MANUALUPDATE.name(), "svs_manualUpdate");
    }
}

