/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data;

import com.visustt.jiveX.general.data.ImageUploadParameter;
import com.visustt.jiveX.general.data.ImportReceivedImage;
import com.visustt.jiveX.general.data.job.JobProcessorDescription;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.net.Localhost;
import java.io.Serializable;

public class RemoteDBNode
implements Serializable {
    public static final String LOCAL_SERVER_NAME = "jiveXLocal";
    public static final int DEFAULT_PORT = 1111;
    public static final int DEFAULT_LOCAL_STORAGE_SCP_PORT = 4499;
    public static final String DEFAULT_SERVICE_NAME = "JiveX";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 180000;
    public static final int DEFAULT_PRIORITY_WEIGHT = 1;
    public static final long serialVersionUID = -12725796786L;
    protected boolean enabled = true;
    protected ImportReceivedImage importReceiveImages = ImportReceivedImage.NONE;
    protected boolean dicomNode;
    protected boolean suppressMaxDicomQuerySize;
    protected String ip;
    protected String localAddress;
    protected int port = 1111;
    protected int localStorageSCPPort = 4499;
    protected int readTimeout = 180000;
    protected int connectTimeout = 5000;
    protected String name;
    protected String description;
    protected String location;
    protected String contactPerson;
    protected double priorityWeight = 1.0;
    protected ImageUploadParameter importParameter;
    protected String requestHandleServiceName = "JiveX";
    protected String retrieveHandleServiceName = "JiveX";
    private String definedLocalAddress;

    public RemoteDBNode() {
    }

    public RemoteDBNode(boolean bl, String string, int n, String string2) {
        this.enabled = bl;
        this.ip = string;
        this.port = n;
        this.name = string2;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getIPAddress() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalStorageSCPPort() {
        return this.localStorageSCPPort;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public double getPriorityWeight() {
        return this.priorityWeight;
    }

    public final ImportReceivedImage getImportReceiveImages() {
        return this.importReceiveImages;
    }

    public ImageUploadParameter getImportParameter() {
        if (this.importParameter == null) {
            this.importParameter = new ImageUploadParameter();
        }
        return this.importParameter;
    }

    public boolean isSuppressMaxDicomQuerySize() {
        return this.suppressMaxDicomQuerySize;
    }

    public String getRequestHandleServiceName() {
        return this.requestHandleServiceName;
    }

    public String getRetrieveHandleServiceName() {
        return this.retrieveHandleServiceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public boolean isDicomNode() {
        return this.dicomNode;
    }

    public void setDicomNode(boolean bl) {
        this.dicomNode = bl;
    }

    public String getDicomNodeName() {
        return this.name;
    }

    public JobProcessorDescription getRetrieveJobProcessorDescription(String string) {
        String string2 = this.getRetrieveHandleServiceName();
        String string3 = string2;
        if (string3.indexOf(64) != -1) {
            string3 = string2.substring(0, string2.indexOf(64));
            string = string2.substring(string2.indexOf(64) + 1);
        }
        JobProcessorDescription jobProcessorDescription = new JobProcessorDescription("RetrieveJobService", string, string3);
        return jobProcessorDescription;
    }

    public void setContactPerson(String string) {
        this.contactPerson = string;
    }

    public void setIPAddress(String string) {
        this.ip = string;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setPriorityWeight(double d) {
        this.priorityWeight = d;
    }

    public void setImportParameter(ImageUploadParameter imageUploadParameter) {
        this.importParameter = imageUploadParameter;
    }

    public void setImportReceiveImages(ImportReceivedImage importReceivedImage) {
        this.importReceiveImages = importReceivedImage;
    }

    public void setRetrieveHandleServiceName(String string) {
        this.retrieveHandleServiceName = string;
    }

    public void setLocalAddress(String string) {
        this.localAddress = string;
        this.definedLocalAddress = StringTool.isDefined(string) ? string : Localhost.getFirstNonLoopbackIP4();
    }

    public void setLocalStorageSCPPort(int n) {
        this.localStorageSCPPort = n;
    }

    public void setRequestHandleServiceName(String string) {
        this.requestHandleServiceName = string;
    }

    public void setSuppressMaxDicomQuerySize(boolean bl) {
        this.suppressMaxDicomQuerySize = bl;
    }

    public String getDefinedLocalAddress() {
        return this.definedLocalAddress;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RemoteDBNode remoteDBNode = (RemoteDBNode)object;
        return !(this.name == null ? remoteDBNode.name != null : !this.name.equals(remoteDBNode.name));
    }

    public String toString() {
        return "RemoteDBNode [enabled=" + this.enabled + ", name=" + this.name + ", ip=" + this.ip + ", port=" + this.port + ", localAddress=" + this.localAddress + ", localStorageSCPPort=" + this.localStorageSCPPort + ", readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", isDicomNode=" + this.dicomNode + ", importReceivedImages=" + this.importReceiveImages + ", importParameter=" + this.importParameter + "]";
    }
}

