/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ImageType {
    public static final String DICOM = "dicom";
    public static final String NO_TYPE = "notype";
    @Deprecated
    public static final String DICOMREDUCED = "dcmred";
    public static final String BLOB_FLAVOR_SUFFIX = "blob";
    public static final String DICOMBLOB = "dicomblob";
    public static final String DICOMZIPBLOB = "dicomzipblob";
    @Deprecated
    public static final String MPEG = "mpeg";
    @Deprecated
    public static final String AVI = "avi";
    public static final String MP4 = "mp4";
    public static final String DICOMZIP = "dicomzip";
    public static final String JPG = "jpg";
    @Deprecated
    public static final String PREVIEW = "pre";
    public static final String JPG2 = "jp2";
    @Deprecated
    public static final String JPG5 = "jp5";
    public static final String DJP = "djp";
    public static final String DICOMJPG8 = "dcmjpg8";
    public static final String DICOMPRE = "dcmpre";
    public static final String DICOMJPG12 = "dcmjpg12";
    public static final String DICOMJPG = "dcmjpg";
    public static final String DICOMJPGLS = "dcmjpgls";
    public static final String DICOMJPG2000 = "dcmjp2k";
    public static final String DICOMJPG2000_LOSSLESS = "dcmjp2kl";
    public static final String DICOMMPEG2 = "dcmmpeg2";
    public static final String PNG = "png";
    public static final String SERIES_PREVIEW = "seriespre";
    public static final String DICOM_ORIGIN_ZIP = "dcmorgzip";
    public static final String DCM_HEADERS = "dcmheaders";
    public static final String PIXEL = "pixel";
    private static final Pattern VALID_FLAVOR_STRING_PATTERN = Pattern.compile("[a-z][a-z0-9_\\-\\.]{0,14}");
    public static final String[] DICOM_IMAGE_LIST = new String[]{"dicom", "dicomzip", "dcmjp2kl", "dcmmpeg2", "dcmorgzip"};
    public static final String[] IMAGE_CREATION_LIST = new String[]{"dicom", "dicomzip", "dcmjp2kl", "dcmjp2k", "dcmjpg", "dcmjpg12", "dcmjpg8", "djp", "dcmjpgls", "dcmmpeg2"};
    public static final String[] ALL_DICOM_FLAVORS = new String[]{"dicom", "dicomzip", "dcmjp2kl", "dcmjp2k", "dcmjpg", "dcmjpg12", "dcmjpg8", "djp", "dcmjpgls", "dcmmpeg2", "dcmpre", "dicomblob", "dicomzipblob", "dcmorgzip"};
    public static final String[] ALL_IMAGE_TYPES_LIST = new String[]{"dicom", "dicomzip", "dcmjp2kl", "dcmjp2k", "mp4", "jpg", "pre", "jp2", "jp5", "djp", "dcmjpg8", "dcmpre", "dicomblob", "dicomzipblob", "dcmjpg12", "dcmjpg", "dcmjpgls", "dcmmpeg2", "png", "seriespre", "dcmorgzip", "dcmheaders", "pixel"};
    public static final String[] DEPRECATED_IMAGE_TYPES_LIST = new String[]{"dcmred", "avi", "mpeg"};
    public static final List<String> VALID_IMAGE_TYPES;
    public static final List<String> COMBINED_IMAGE_TYPE_DCMHEADERS_PIXEL;
    static final Map<String, Double> C_FACTOR_TABLE;
    static final HashMap<String, String> TS_IT_MAP;

    private ImageType() {
    }

    public static final String getImageTypeFromTransferSyntax(String string) {
        return TS_IT_MAP.get(string);
    }

    public static final double getCompressionFactor(String string) {
        if (!ImageType.isValidType(string)) {
            return 1.0;
        }
        return C_FACTOR_TABLE.get(string);
    }

    public static String getSpecialImageType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(95);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static boolean isSpecialImageType(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(95);
        return n != -1;
    }

    public static boolean isZipImageType(String string) {
        return DICOMZIP.equals(string) || DICOMREDUCED.equals(string) || DICOMPRE.equals(string) || DICOMZIPBLOB.equals(string) || DICOM_ORIGIN_ZIP.equals(string);
    }

    public static final boolean isJPEG(String string) {
        return JPG.equals(string) || PREVIEW.equals(string) || JPG2.equals(string) || JPG5.equals(string) || SERIES_PREVIEW.equals(string);
    }

    public static final boolean isValidType(String string) {
        if (string == null) {
            return false;
        }
        return DICOM.equals(string) || DICOMZIP.equals(string) || JPG.equals(string) || JPG2.equals(string) || DICOMREDUCED.equals(string) || JPG5.equals(string) || DICOMJPG8.equals(string) || DICOMPRE.equals(string) || DICOMJPG12.equals(string) || DICOMJPG.equals(string) || PREVIEW.equals(string) || DJP.equals(string) || MP4.equals(string) || DICOMJPG2000.equals(string) || PNG.equals(string) || DICOMJPG2000_LOSSLESS.equals(string) || DICOMJPGLS.equals(string) || DICOMMPEG2.equals(string) || DICOMBLOB.equals(string) || NO_TYPE.equals(string) || DICOMZIPBLOB.equals(string) || SERIES_PREVIEW.equals(string) || DICOM_ORIGIN_ZIP.equals(string) || DCM_HEADERS.equals(string) || PIXEL.equals(string);
    }

    public static final boolean isValidFlavorToken(String string) {
        if (string == null) {
            return false;
        }
        return VALID_FLAVOR_STRING_PATTERN.matcher(string).matches();
    }

    public static final boolean isDicom(String string) {
        if (string == null) {
            return false;
        }
        return DICOM.equals(string) || DICOMZIP.equals(string) || DICOMJPG8.equals(string) || DICOMJPG12.equals(string) || DICOMJPG.equals(string) || string.equals(DJP) || DICOMJPG2000.equals(string) || DICOMJPG2000_LOSSLESS.equals(string) || DICOMREDUCED.equals(string) || DICOMPRE.equals(string) || DICOMBLOB.equals(string) || DICOMZIPBLOB.equals(string) || DICOMJPGLS.equals(string) || DICOMMPEG2.equals(string) || DICOM_ORIGIN_ZIP.equals(string);
    }

    public static final boolean isMovie(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(MP4) || string.equals(AVI) || string.equals(MPEG) || string.equals(DICOMMPEG2);
    }

    public static final boolean isMultiFrame(String string) {
        return MP4.equals(string) || AVI.equals(string) || MPEG.equals(string) || DICOMREDUCED.equals(string);
    }

    public static final boolean isLosslessImage(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DICOM) || string.equals(DICOMZIP) || string.equals(DICOMBLOB) || string.equals(DICOMZIPBLOB) || string.equals(DICOMJPG2000_LOSSLESS) || string.equals(DICOM_ORIGIN_ZIP);
    }

    public static final boolean isObsolete(String string) {
        return AVI.equals(string) || MPEG.equals(string) || DICOMREDUCED.equals(string);
    }

    public static boolean isDicomJPEG(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DICOMJPG12) || string.equals(DICOMJPG8) || string.equals(DJP) || string.equals(DICOMJPG) || string.equals(DICOMJPGLS);
    }

    public static boolean isDicomJPEG2000(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DICOMJPG2000) || string.equals(DICOMJPG2000_LOSSLESS);
    }

    public static boolean isSingleFileFlavor(String string) {
        if (string == null) {
            return false;
        }
        return SERIES_PREVIEW.equals(string) || DICOMZIPBLOB.equals(string) || DICOMBLOB.equals(string) || DCM_HEADERS.equals(string);
    }

    public static final boolean isDeprecatedDontCreateFlavorsFromLossyFlavor(String string) {
        if (string == null) {
            return false;
        }
        switch (string) {
            case "dcmjpg": 
            case "dcmjpg12": 
            case "dcmjpg8": 
            case "dcmmpeg2": 
            case "dcmjpgls": {
                return true;
            }
        }
        return false;
    }

    public static List<String> getImageTypesWithObsolete() {
        ArrayList<String> arrayList = new ArrayList<String>(0);
        arrayList.addAll(Arrays.asList(ALL_IMAGE_TYPES_LIST));
        arrayList.addAll(Arrays.asList(DEPRECATED_IMAGE_TYPES_LIST));
        return arrayList;
    }

    public static boolean isDicomZip(String string) {
        if (string == null) {
            return false;
        }
        return DICOM_ORIGIN_ZIP.equals(string) || DICOMZIP.equals(string);
    }

    public static boolean isDicomHeaderOrPixel(String string) {
        if (string == null) {
            return false;
        }
        return DCM_HEADERS.equals(string) || PIXEL.equals(string);
    }

    static {
        COMBINED_IMAGE_TYPE_DCMHEADERS_PIXEL = Collections.unmodifiableList(Arrays.asList(DCM_HEADERS, PIXEL));
        C_FACTOR_TABLE = new Hashtable<String, Double>();
        C_FACTOR_TABLE.put(DICOM, 1.0);
        C_FACTOR_TABLE.put(MP4, 1.0);
        C_FACTOR_TABLE.put(DICOMZIP, 0.58);
        C_FACTOR_TABLE.put(JPG, 0.04);
        C_FACTOR_TABLE.put(PREVIEW, 1.0E-7);
        C_FACTOR_TABLE.put(JPG2, 0.02);
        C_FACTOR_TABLE.put(JPG5, 0.05);
        C_FACTOR_TABLE.put(DJP, 0.05);
        C_FACTOR_TABLE.put(DICOMJPG8, 0.1);
        C_FACTOR_TABLE.put(DICOMPRE, 1.0);
        C_FACTOR_TABLE.put(DICOMJPG12, 0.75);
        C_FACTOR_TABLE.put(DICOMJPG, 0.17);
        C_FACTOR_TABLE.put(DICOMJPG2000, 0.08);
        C_FACTOR_TABLE.put(DICOMJPG2000_LOSSLESS, 0.37);
        C_FACTOR_TABLE.put(PNG, 0.01);
        C_FACTOR_TABLE.put(DICOMJPGLS, 0.3);
        C_FACTOR_TABLE.put(DICOMMPEG2, 1.0);
        C_FACTOR_TABLE.put(DICOM_ORIGIN_ZIP, 0.58);
        VALID_IMAGE_TYPES = ImageType.getImageTypesWithObsolete();
        TS_IT_MAP = new HashMap();
        TS_IT_MAP.put("1.2.840.10008.1.2.2", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2.1", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.96", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.91", DICOMJPG2000);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.90", DICOMJPG2000_LOSSLESS);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.50", DICOMJPG8);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.51", DICOMJPG12);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.57", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.70", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2.5", DICOM);
        TS_IT_MAP.put("1.2.276.0.50.1.2.2", DICOMZIP);
        TS_IT_MAP.put("1.2.276.0.50.1.2.1", DICOMZIP);
        TS_IT_MAP.put("1.2.276.0.50.1.2", DICOMZIP);
        TS_IT_MAP.put("1.2.276.0.50.1.2.5", DICOMZIP);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.80", DICOM);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.81", DICOMJPGLS);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.100", DICOMMPEG2);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.101", DICOMMPEG2);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.102", DICOMMPEG2);
        TS_IT_MAP.put("1.2.840.10008.1.2.4.103", DICOMMPEG2);
    }
}

