/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.criteria.manager;

import com.visustt.jiveX.general.criteria.manager.CriteriaDataEvent;
import com.visustt.jiveX.general.criteria.manager.CriteriaDataList;
import com.visustt.jiveX.general.criteria.manager.CriteriaDataListener;
import com.visustt.jiveX.general.criteria.manager.CriteriaDataSource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class CriteriaDataManager
implements CriteriaDataListener {
    public static final String CFG_CONFIGURATION_ELEMENT = "CriteriaManager";
    public static final String CFG_DATA_SOURCE_ELEMENT = "CriteriaDataSource";
    private final CriteriaDataList dataList = new CriteriaDataList();
    private final List<CriteriaDataSource> sourceList;
    private Calendar lastChangeTime = null;

    public CriteriaDataManager() {
        this.dataList.addListener(this);
        this.sourceList = new ArrayList<CriteriaDataSource>();
    }

    public CriteriaDataList getDataList() {
        return this.dataList;
    }

    public void setDataList(CriteriaDataList criteriaDataList, boolean bl) {
        this.dataList.reset(criteriaDataList, bl);
    }

    public boolean registerSource(CriteriaDataSource criteriaDataSource) {
        try {
            if (criteriaDataSource == null) {
                throw new IllegalArgumentException("Criteria data source to add cannot be null.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw CriteriaDataManager.a(illegalArgumentException);
        }
        try {
            if (!this.sourceList.contains(criteriaDataSource)) {
                return this.sourceList.add(criteriaDataSource);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw CriteriaDataManager.a(illegalArgumentException);
        }
        return false;
    }

    public boolean unregisterSource(CriteriaDataSource criteriaDataSource) {
        try {
            if (criteriaDataSource == null) {
                throw new IllegalArgumentException("Criteria data source to unregister cannot be null.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw CriteriaDataManager.a(illegalArgumentException);
        }
        return this.sourceList.remove(criteriaDataSource);
    }

    public List<CriteriaDataSource> getSourceList() {
        return new ArrayList<CriteriaDataSource>(this.sourceList);
    }

    public Calendar getLastChangeTime() {
        try {
            if (this.lastChangeTime == null) {
                this.lastChangeTime = Calendar.getInstance();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw CriteriaDataManager.a(illegalArgumentException);
        }
        return this.lastChangeTime;
    }

    public boolean hasChangedInMeantime(Calendar calendar) {
        boolean bl;
        block7: {
            block6: {
                try {
                    try {
                        try {
                            if (calendar == null || this.lastChangeTime == null) break block6;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw CriteriaDataManager.a(illegalArgumentException);
                        }
                        if (calendar.compareTo(this.lastChangeTime) >= 0) break block6;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw CriteriaDataManager.a(illegalArgumentException);
                    }
                    bl = true;
                    break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw CriteriaDataManager.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void modelChanged(CriteriaDataEvent criteriaDataEvent) {
        if (this.lastChangeTime != null) {
            for (CriteriaDataSource criteriaDataSource : this.sourceList) {
                criteriaDataSource.modelChanged(criteriaDataEvent);
            }
        }
        this.lastChangeTime = Calendar.getInstance();
    }

    public void destroy() {
        this.lastChangeTime = null;
        this.sourceList.clear();
        this.dataList.reset();
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

