/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.criteria;

import com.visustt.dicomTk.DicomTagNames;
import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.jiveX.general.criteria.CriteriaSet;
import com.visustt.jiveX.general.criteria.CriterionResolver;
import com.visustt.jiveX.general.criteria.CriterionResolverAdapter;
import com.visustt.jiveX.general.criteria.CriterionResolverImpl;
import com.visustt.jiveX.general.criteria.SeriesCriteria;
import com.visustt.jiveX.general.criteria.StudyCriteriaUtil;
import com.visustt.tools.config.main.ConfigurationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;

public class StudyCriteria
implements CriteriaSet,
Serializable {
    private static final long serialVersionUID = 201412241030L;
    private List<CriterionResolver> studyCriteria;
    private List<SeriesCriteria> seriesCriteria;
    private boolean isMainStudyCriteria;

    public StudyCriteria() {
        this(false);
    }

    public StudyCriteria(boolean bl) {
        this.studyCriteria = new ArrayList<CriterionResolver>();
        this.seriesCriteria = new ArrayList<SeriesCriteria>();
        this.isMainStudyCriteria = false;
        this.isMainStudyCriteria = bl;
    }

    public StudyCriteria(ConfigurationElement configurationElement) throws ConfigurationException {
        block13: {
            ConfigurationElement[] configurationElementArray;
            block12: {
                block11: {
                    this.studyCriteria = new ArrayList<CriterionResolver>();
                    this.seriesCriteria = new ArrayList<SeriesCriteria>();
                    this.isMainStudyCriteria = false;
                    Vector vector = configurationElement.getAttribute("mainstudy");
                    try {
                        if (vector == null || vector.size() != 1) break block11;
                    }
                    catch (ConfigurationException configurationException) {
                        throw StudyCriteria.a(configurationException);
                    }
                    ConfigurationElement[] configurationElementArray2 = (ConfigurationElement[])vector.get(0);
                    try {
                        this.isMainStudyCriteria = configurationElementArray2.equalsIgnoreCase("true");
                    }
                    catch (ConfigurationException configurationException) {
                        throw StudyCriteria.a(configurationException);
                    }
                }
                ConfigurationElement[] configurationElementArray3 = configurationElement.getAllChildrenWithName("Criteria");
                configurationElementArray = configurationElement.getAllChildrenWithName("SeriesCriteria");
                try {
                    if (configurationElementArray3 == null || configurationElementArray3.length <= 0) break block12;
                }
                catch (ConfigurationException configurationException) {
                    throw StudyCriteria.a(configurationException);
                }
                for (ConfigurationElement configurationElement2 : configurationElementArray3) {
                    if (!configurationElement2.checkForAttribute("uid")) continue;
                    UUID uUID = UUID.fromString(configurationElement2.getStringValue("uid"));
                    Boolean bl = false;
                    if (configurationElement2.checkForAttribute("negate")) {
                        bl = configurationElement2.getBooleanValue("negate");
                    }
                    CriterionResolverImpl criterionResolverImpl = null;
                    criterionResolverImpl = new CriterionResolverImpl(uUID, bl);
                    this.studyCriteria.add(criterionResolverImpl);
                }
            }
            try {
                if (configurationElementArray == null || configurationElementArray.length <= 0) break block13;
            }
            catch (ConfigurationException configurationException) {
                throw StudyCriteria.a(configurationException);
            }
            for (ConfigurationElement configurationElement2 : configurationElementArray) {
                this.seriesCriteria.add(new SeriesCriteria(configurationElement2));
            }
        }
    }

    public void add(CriterionResolver criterionResolver) {
        this.studyCriteria.add(criterionResolver);
    }

    public boolean isMainStudyCriteria() {
        return this.isMainStudyCriteria;
    }

    public void setIsMainStudyCriteria(boolean bl) {
        this.isMainStudyCriteria = bl;
    }

    @Override
    public List<CriterionResolver> getCriteriaList() {
        return this.studyCriteria;
    }

    public List<SeriesCriteria> getSeriesCriteriaList() {
        return this.seriesCriteria;
    }

    public void addSeriesCriteria(SeriesCriteria seriesCriteria) {
        this.seriesCriteria.add(seriesCriteria);
    }

    public boolean isEmpty() {
        return this.studyCriteria.isEmpty() && this.seriesCriteria.isEmpty();
    }

    public boolean isStudyCriteriaEmpty() {
        return this.studyCriteria.isEmpty();
    }

    public boolean isSeriesCriteriaEmpty() {
        return this.seriesCriteria.isEmpty();
    }

    public ConfigurationElement createXMLConfiguration() {
        ConfigurationElement configurationElement = new ConfigurationElement("StudyCriteria");
        String string = this.isMainStudyCriteria ? "true" : "false";
        configurationElement.addAttribute("mainstudy", string);
        for (CriterionResolver serializable : this.studyCriteria) {
            if (serializable == null || serializable instanceof CriterionResolverAdapter) continue;
            ConfigurationElement configurationElement2 = new ConfigurationElement("Criteria");
            configurationElement2.addAttribute("uid", serializable.getUUID().toString());
            configurationElement2.addAttribute("negate", Boolean.toString(serializable.isNegated()));
            configurationElement.addChild(configurationElement2);
        }
        for (SeriesCriteria seriesCriteria : this.seriesCriteria) {
            configurationElement.addChild(seriesCriteria.createXMLConfiguration());
        }
        return configurationElement;
    }

    public List<UUID> getStudyCriteriaUUIDs() {
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        for (CriterionResolver criterionResolver : this.studyCriteria) {
            arrayList.add(criterionResolver.getUUID());
        }
        return arrayList;
    }

    public CriterionResolverAdapter getOldCriterion(String string) {
        for (CriterionResolver criterionResolver : this.studyCriteria) {
            CriterionResolverAdapter criterionResolverAdapter;
            if (!(criterionResolver instanceof CriterionResolverAdapter) || !(criterionResolverAdapter = (CriterionResolverAdapter)criterionResolver).getOldCriterionType().equalsIgnoreCase(string)) continue;
            return criterionResolverAdapter;
        }
        return null;
    }

    public StudyCriteria copy() {
        StudyCriteria studyCriteria = new StudyCriteria();
        studyCriteria.isMainStudyCriteria = this.isMainStudyCriteria;
        studyCriteria.studyCriteria = this.copyOrCloneStudyCriteria();
        studyCriteria.seriesCriteria = new ArrayList<SeriesCriteria>();
        for (SeriesCriteria seriesCriteria : this.seriesCriteria) {
            studyCriteria.seriesCriteria.add(seriesCriteria.copy());
        }
        return studyCriteria;
    }

    private List<CriterionResolver> copyOrCloneStudyCriteria() {
        if (this.isOldStudyCriteria()) {
            return new ArrayList<CriterionResolver>(this.cloneOldStudyCriteria());
        }
        return new ArrayList<CriterionResolver>(this.studyCriteria);
    }

    private List<CriterionResolver> cloneOldStudyCriteria() {
        ArrayList<CriterionResolver> arrayList = new ArrayList<CriterionResolver>();
        if (this.isOldStudyCriteria()) {
            CriterionResolverAdapter criterionResolverAdapter = (CriterionResolverAdapter)this.studyCriteria.get(0);
            CriterionResolverAdapter criterionResolverAdapter2 = (CriterionResolverAdapter)this.studyCriteria.get(1);
            StudyCriteria studyCriteria = StudyCriteriaUtil.createStudyCriteria(criterionResolverAdapter.getOldCriterionValue(), criterionResolverAdapter2.getOldCriterionValue());
            arrayList.addAll(studyCriteria.getCriteriaList());
        }
        return arrayList;
    }

    protected boolean isOldStudyCriteria() {
        if (this.studyCriteria.size() == 2 && this.studyCriteria.get(0) instanceof CriterionResolverAdapter && this.studyCriteria.get(1) instanceof CriterionResolverAdapter) {
            CriterionResolverAdapter criterionResolverAdapter = (CriterionResolverAdapter)this.studyCriteria.get(0);
            if (!criterionResolverAdapter.getOldCriterionType().equalsIgnoreCase(DicomTagNames.TAG_modality.toString())) {
                return false;
            }
            CriterionResolverAdapter criterionResolverAdapter2 = (CriterionResolverAdapter)this.studyCriteria.get(1);
            return criterionResolverAdapter2.getOldCriterionType().equalsIgnoreCase(DicomTagNames.TAG_studyDescription.toString());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StudyCriteria studyCriteria = (StudyCriteria)object;
        return this.isMainStudyCriteria == studyCriteria.isMainStudyCriteria && this.studyCriteria.equals(studyCriteria.studyCriteria) && this.seriesCriteria.equals(studyCriteria.seriesCriteria);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[isMainStudyCriteria: " + this.isMainStudyCriteria);
        for (CriterionResolver serializable : this.studyCriteria) {
            stringBuffer.append(", study criterion: " + serializable);
        }
        if (this.seriesCriteria.size() > 0) {
            stringBuffer.append("Series criteria:\n");
            for (SeriesCriteria seriesCriteria : this.seriesCriteria) {
                stringBuffer.append(seriesCriteria);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = 13;
        for (CriterionResolver object : this.studyCriteria) {
            n2 += object.hashCode();
        }
        n = n * 3 + n2;
        int n3 = 17;
        for (SeriesCriteria seriesCriteria : this.seriesCriteria) {
            n3 += seriesCriteria.hashCode();
        }
        n = n * 5 + n3;
        n = n * 5 + (this.isMainStudyCriteria ? 11 : 7);
        return n;
    }

    public int compareTo(Object object) {
        StudyCriteria studyCriteria = (StudyCriteria)object;
        if (!this.isStudyCriteriaEmpty() && studyCriteria.isStudyCriteriaEmpty()) {
            return -1;
        }
        if (this.isStudyCriteriaEmpty() && !studyCriteria.isStudyCriteriaEmpty()) {
            return 1;
        }
        if (this.isStudyCriteriaEmpty() && studyCriteria.isStudyCriteriaEmpty()) {
            if (!this.isSeriesCriteriaEmpty() && studyCriteria.isSeriesCriteriaEmpty()) {
                return -1;
            }
            if (this.isSeriesCriteriaEmpty() && !studyCriteria.isSeriesCriteriaEmpty()) {
                return 1;
            }
        }
        return 0;
    }

    private static ConfigurationException a(ConfigurationException configurationException) {
        return configurationException;
    }
}

