/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.config;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import java.io.File;
import java.io.FileNotFoundException;

public class ServerConfigurationFolder {
    public static final String SERVICES_CONFIGURATION_DIRECTORY = "jx.cfg.services.dir";
    public static final String SERVICES_SHARED_CONFIGURATION_DIRECTORY = "jx.cs.sharedConfigurationFolder";
    private static File SHARED_CONFIG_FOLDER;
    private static File LOCAL_CONFIG_FOLDER;
    private static String BACKUP_FOLDER_NAME;
    private static String PROFILE_FOLDER_NAME;
    private static String TEMPLATES_FOLDER_NAME;
    private static String FALLBACK_FOLDER_NAME;
    private static Logger logger;

    private ServerConfigurationFolder() {
    }

    @Deprecated
    public static void initConfigPath() {
        String string = System.getProperty(SERVICES_CONFIGURATION_DIRECTORY, "cfg");
        LOCAL_CONFIG_FOLDER = new File(string);
        String string2 = System.getProperty(SERVICES_SHARED_CONFIGURATION_DIRECTORY);
        SHARED_CONFIG_FOLDER = StringTool.isDefined(string2) ? new File(string2) : null;
    }

    public static File getSharedConfigurationFolderRead() {
        if (SHARED_CONFIG_FOLDER != null) {
            File file = SHARED_CONFIG_FOLDER;
            if (file.exists()) {
                logger.info("Get shared config path to " + SHARED_CONFIG_FOLDER.getAbsolutePath());
                return file;
            }
            logger.warn("Get shared config path NOT available " + SHARED_CONFIG_FOLDER.getAbsolutePath());
            return new File(FALLBACK_FOLDER_NAME);
        }
        return null;
    }

    public static File getSharedConfigurationFolderWrite() throws FileNotFoundException {
        if (SHARED_CONFIG_FOLDER != null) {
            File file = new File(SHARED_CONFIG_FOLDER.getAbsolutePath());
            try {
                if (file.exists()) {
                    logger.info("Get shared config path to " + SHARED_CONFIG_FOLDER.getAbsolutePath());
                    return file;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw ServerConfigurationFolder.a(fileNotFoundException);
            }
        }
        throw new FileNotFoundException("Shared Configuration Path not available. No config writing possible!");
    }

    public static File getLocalConfigurationFolder() {
        return LOCAL_CONFIG_FOLDER;
    }

    public static File getBackUpConfigurationFolder(String string) {
        File file = new File(string + BACKUP_FOLDER_NAME);
        if (file.mkdir()) {
            logger.info("BackUp folder not found, create local backup folder under " + file.getAbsolutePath());
        }
        if (file.exists()) {
            logger.info("Get backup config folder path" + file.getAbsolutePath());
            return file;
        }
        return file;
    }

    public static File getLocalProfileConfigurationFolder() {
        return new File(ServerConfigurationFolder.getLocalConfigurationFolder(), PROFILE_FOLDER_NAME);
    }

    public static File getSharedProfileConfigurationFolder() {
        return new File(ServerConfigurationFolder.getSharedConfigurationFolderRead(), PROFILE_FOLDER_NAME);
    }

    public static File getLocalTemplatesConfigurationFolder() {
        return new File(ServerConfigurationFolder.getLocalConfigurationFolder(), TEMPLATES_FOLDER_NAME);
    }

    public static File getSharedTemplatesConfigurationFolder() {
        return new File(ServerConfigurationFolder.getSharedConfigurationFolderRead(), TEMPLATES_FOLDER_NAME);
    }

    public static File getSharedConfigFolder() {
        return SHARED_CONFIG_FOLDER;
    }

    public static boolean useSharedConfigFolder() {
        return SHARED_CONFIG_FOLDER != null;
    }

    static {
        BACKUP_FOLDER_NAME = "/backup";
        PROFILE_FOLDER_NAME = "/templates/profiles";
        TEMPLATES_FOLDER_NAME = "/templates";
        FALLBACK_FOLDER_NAME = "./cfg_storage/lastKnownGood";
        logger = LoggerFactory.getInstance("ServerConfigurationFolder");
        ServerConfigurationFolder.initConfigPath();
    }

    private static FileNotFoundException a(FileNotFoundException fileNotFoundException) {
        return fileNotFoundException;
    }
}

