/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jTools.configManager.main;

import com.visustt.jTools.configManager.main.Element;
import com.visustt.tools.config.main.ConfigurationException;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ConfigurationElement
extends Element
implements TreeNode {
    static final long serialVersionUID = -6380268613784381857L;
    private static final Logger logger = LoggerFactory.getInstance("jx.config");
    private static final String BLANKS_ERROR_MSG = "Child- and Attributenames with blanks aren't allowed and will be ignored: ";
    private static final char[] ILLEGAL_XML_TAG_NAME_CHARS = new char[]{'@', ';', '#', '$', '%', '^', '(', ')', '+', '='};
    public static final String TRANSIENT_KEY = "TRANSIENT";
    private static final String[] CHILD_IDENTIFIER = new String[]{"name", "alias", "IP", "description"};
    protected String configurationName;
    protected final Hashtable<KeyString, Vector<?>> attributes;
    protected final Vector originalAttributeKeys;
    protected final Hashtable attributeComments;
    protected final Vector<ConfigurationElement> children;
    protected ConfigurationElement parent;
    protected String definitionID = null;
    protected String configurationVersion = null;
    protected Object body;
    protected String comment;
    private HashSet requestedAttributes;
    private String bodyComment;
    private boolean useCRBetweenAttributes = false;
    private int maxAttributeLineLength = 80;
    private String characterEncoding = null;
    private int maxMergeDepth = Integer.MAX_VALUE;
    private boolean requestedAttributesEnabled = true;
    private String includeConfigFile;
    private String includeConfigComment;
    private boolean includeConfigModified;

    public ConfigurationElement(String string, ConfigurationElement configurationElement) {
        this.configurationName = ConfigurationElement.fixTagName(string);
        this.attributes = new Hashtable();
        this.originalAttributeKeys = new Vector();
        this.attributeComments = new Hashtable(0);
        this.children = new Vector(5);
        this.parent = configurationElement;
        this.body = null;
        this.comment = "";
        if (configurationElement != null) {
            this.definitionID = configurationElement.definitionID;
            this.configurationVersion = configurationElement.configurationVersion;
            configurationElement.addChild(this);
        }
    }

    public ConfigurationElement(String string) {
        this(string, null);
    }

    public ConfigurationElement() {
        this(null, null);
    }

    public ConfigurationElement(ConfigurationElement configurationElement) {
        this.attributeComments = configurationElement.attributeComments;
        this.attributes = configurationElement.attributes;
        this.body = configurationElement.body;
        this.bodyComment = configurationElement.bodyComment;
        this.characterEncoding = configurationElement.characterEncoding;
        this.children = configurationElement.children;
        this.comment = configurationElement.comment;
        this.configurationName = configurationElement.configurationName;
        this.definitionID = configurationElement.definitionID;
        this.configurationVersion = configurationElement.configurationVersion;
        this.originalAttributeKeys = new Vector(configurationElement.originalAttributeKeys);
        this.parent = configurationElement.parent;
        this.includeConfigFile = configurationElement.includeConfigFile;
        this.includeConfigModified = configurationElement.includeConfigModified;
    }

    public final void setIncludeConfigFile(String string) {
        this.includeConfigFile = string;
    }

    public final String getIncludeConfigFile() {
        return this.includeConfigFile;
    }

    public final void setIncludeConfigModified(boolean bl) {
        this.includeConfigModified = bl;
    }

    public final boolean isIncludeConfigModified() {
        return this.includeConfigModified;
    }

    public void setIncludeConfigComment(String string) {
        this.includeConfigComment = string;
    }

    public String getIncludeConfigComment() {
        return this.includeConfigComment;
    }

    public void sortChildren() {
        this.sortChildren(false);
    }

    public void sortChildren(boolean bl) {
        Collections.sort(this.children, new Comparator<ConfigurationElement>(){

            @Override
            public int compare(ConfigurationElement configurationElement, ConfigurationElement configurationElement2) {
                ConfigurationElement configurationElement3;
                Object object = "";
                Object object2 = "";
                if (configurationElement != null) {
                    configurationElement3 = configurationElement;
                    object = String.valueOf(configurationElement3.getName()).toLowerCase();
                    try {
                        object = (String)object + configurationElement3.getStringValue("name", "").toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (configurationElement2 != null) {
                    configurationElement3 = configurationElement2;
                    object2 = String.valueOf(configurationElement3.getName()).toLowerCase();
                    try {
                        object2 = (String)object2 + configurationElement3.getStringValue("name", "").toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return ((String)object).compareTo((String)object2);
            }
        });
        if (bl) {
            for (ConfigurationElement configurationElement : this.children) {
                try {
                    if (configurationElement.isLeaf()) continue;
                    configurationElement.sortChildren(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
        }
    }

    public static String fixTagName(String string) {
        Object object = null;
        if (string != null) {
            block6: {
                object = string;
                try {
                    if (!Character.isDigit(((String)object).charAt(0)) && !((String)object).startsWith("xml")) break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                object = "_" + (String)object;
            }
            int n = 0;
            while (true) {
                block7: {
                    try {
                        if (n >= ILLEGAL_XML_TAG_NAME_CHARS.length) break;
                        if (((String)object).indexOf(ILLEGAL_XML_TAG_NAME_CHARS[n]) == -1) break block7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                    object = ((String)object).replace(ILLEGAL_XML_TAG_NAME_CHARS[n], '_');
                }
                ++n;
            }
        }
        return object;
    }

    public void addAttribute(String string, List<?> list) {
        KeyString keyString = new KeyString(string);
        try {
            this.attributes.remove(keyString);
            this.attributes.put(keyString, new Vector(list));
            if (!this.originalAttributeKeys.contains(string)) {
                this.originalAttributeKeys.addElement(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
    }

    public void addAttribute(String string, Vector<?> vector) {
        KeyString keyString = new KeyString(string);
        try {
            this.attributes.remove(keyString);
            this.attributes.put(keyString, vector);
            if (!this.originalAttributeKeys.contains(string)) {
                this.originalAttributeKeys.addElement(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
    }

    public void addAttribute(String string, String string2) {
        Vector<String> vector = new Vector<String>(1, 1);
        vector.addElement(this.removeIllegalCharacters(string2));
        this.addAttribute(string, vector);
    }

    public void addAttribute(String string, int n) {
        Vector<Integer> vector = new Vector<Integer>(1, 1);
        vector.addElement(n);
        this.addAttribute(string, vector);
    }

    public void addAttribute(String string, double d) {
        Vector<Double> vector = new Vector<Double>(1, 1);
        vector.addElement(d);
        this.addAttribute(string, vector);
    }

    public void addAttribute(String string, long l) {
        Vector<Long> vector = new Vector<Long>(1, 1);
        vector.addElement(l);
        this.addAttribute(string, vector);
    }

    public void addAttribute(String string, byte by) {
        Vector<Byte> vector = new Vector<Byte>(1, 1);
        vector.addElement(by);
        this.addAttribute(string, vector);
    }

    public void addAttribute(String string, boolean bl) {
        Vector<Boolean> vector = new Vector<Boolean>(1, 1);
        vector.addElement(bl);
        this.addAttribute(string, vector);
    }

    void addAttributeComment(String string, String string2) {
        this.attributeComments.put(new KeyString(string), string2);
    }

    private void addChildSetDisabled(ConfigurationElement configurationElement) {
        if (!this.isExisting(configurationElement)) {
            block9: {
                try {
                    block8: {
                        try {
                            if (!configurationElement.checkForAttribute("enabled")) break block8;
                            configurationElement.setValueAtIndex("enabled", "false", 0);
                            break block9;
                        }
                        catch (Exception exception) {
                            throw ConfigurationElement.a(exception);
                        }
                    }
                    try {
                        if (configurationElement.checkForAttribute("Enabled")) {
                            configurationElement.setValueAtIndex("Enabled", "false", 0);
                        }
                    }
                    catch (Exception exception) {
                        throw ConfigurationElement.a(exception);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("Unable to change \"enabled\" flag to \"false\". Please check configuration." + exception), exception);
                }
            }
            this.children.addElement(configurationElement);
        }
    }

    public void addChild(ConfigurationElement configurationElement) {
        try {
            if (!this.isExisting(configurationElement)) {
                this.children.addElement(configurationElement);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
    }

    public void addChildAt(ConfigurationElement configurationElement, int n) {
        block6: {
            block8: {
                block7: {
                    try {
                        try {
                            if (this.isExisting(configurationElement)) break block6;
                            if (n <= this.children.size()) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ConfigurationElement.a(illegalArgumentException);
                        }
                        this.children.addElement(configurationElement);
                        break block6;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                }
                try {
                    if (n >= 0) break block8;
                    this.children.insertElementAt(configurationElement, 0);
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
            this.children.insertElementAt(configurationElement, n);
        }
    }

    public void addValue(String string, Object object) {
        Vector<?> vector = this.attributes.get(new KeyString(string));
        vector.addElement(object);
    }

    public boolean checkForAttribute(String string) {
        return this.checkForAttribute(new KeyString(string));
    }

    private boolean checkForAttribute(KeyString keyString) {
        boolean bl;
        Vector vector = this.getAttribute_(keyString);
        try {
            bl = vector != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        return bl;
    }

    public Enumeration<ConfigurationElement> children() {
        return this.children.elements();
    }

    public Vector<ConfigurationElement> getAllChildren() {
        return this.children;
    }

    public Vector<String> getAllChildrenPaths(String string) {
        Object object;
        String string2;
        Object object2;
        String string3;
        Vector<String> vector;
        block10: {
            vector = new Vector<String>();
            string3 = null;
            try {
                int n = 0;
                while (true) {
                    block11: {
                        try {
                            if (n >= CHILD_IDENTIFIER.length) break block10;
                            if (!this.checkForAttribute(CHILD_IDENTIFIER[n])) break block11;
                        }
                        catch (Exception exception) {
                            throw ConfigurationElement.a(exception);
                        }
                        string3 = this.getStringValue(CHILD_IDENTIFIER[n]);
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Unable to resolve child's identifier.", exception);
            }
        }
        try {
            object2 = string == null ? "" : string + File.separator;
        }
        catch (Exception exception) {
            throw ConfigurationElement.a(exception);
        }
        try {
            string2 = this.getName();
            object = StringTool.isDefined(string3) ? " <" + string3 + ">" : "";
        }
        catch (Exception exception) {
            throw ConfigurationElement.a(exception);
        }
        String string4 = (String)object2 + string2 + (String)object;
        vector.add(string4);
        for (ConfigurationElement configurationElement : this.children) {
            vector.addAll(configurationElement.getAllChildrenPaths(string4));
        }
        return vector;
    }

    public ConfigurationElement[] getAllChildrenWithName(String string) throws ConfigurationException {
        try {
            if (string == null) {
                throw new ConfigurationException("Element name could not be null!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        ConfigurationElement.assertNoWhitespaceInName(string);
        ArrayList<ConfigurationElement> arrayList = new ArrayList<ConfigurationElement>(this.children.size());
        for (ConfigurationElement configurationElement : this.children) {
            if (configurationElement == null || !string.equalsIgnoreCase(configurationElement.getName())) continue;
            arrayList.add(configurationElement);
        }
        int n = arrayList.size();
        ConfigurationElement[] configurationElementArray = new ConfigurationElement[n];
        System.arraycopy(arrayList.toArray(), 0, configurationElementArray, 0, n);
        return configurationElementArray;
    }

    private static void assertNoWhitespaceInName(String string) {
        if (string.indexOf(" ") != -1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BLANKS_ERROR_MSG + string);
            illegalArgumentException.fillInStackTrace();
            logger.error((Object)(":" + illegalArgumentException), illegalArgumentException);
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public Vector getAttribute(String string) {
        return this.getAttribute_(this.registerAttributeNameAndGetKey(string));
    }

    private final Vector getAttribute_(String string) {
        return this.getAttribute_(new KeyString(string));
    }

    private final Vector getAttribute_(KeyString keyString) {
        ConfigurationElement.assertNoWhitespaceInName(keyString.toString());
        return this.attributes.get(keyString);
    }

    private final Vector getAttributeWithCheck(KeyString keyString) throws ConfigurationException {
        Vector<?> vector = this.attributes.get(keyString);
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        if (vector == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The required attribute '");
            stringBuffer.append(keyString.toString());
            stringBuffer.append("' is not found in '");
            stringBuffer.append(this.getPathToRoot());
            stringBuffer.append("'!");
            throw new ConfigurationException(stringBuffer.toString());
        }
        return vector;
    }

    public int[] getAttributeAsIntArray(String string) throws ConfigurationException {
        int n = this.getValueCount(string);
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2 = this.getIntValueAt(string, i);
        }
        return nArray;
    }

    public long[] getAttributeAsLongArray(String string) throws ConfigurationException {
        int n = this.getValueCount(string);
        long[] lArray = new long[n];
        try {
            for (int i = 0; i < n; ++i) {
                lArray[i] = this.getLongValueAt(string, i);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        return lArray;
    }

    public float[] getAttributeAsFloatArray(String string) throws ConfigurationException {
        int n = this.getValueCount(string);
        float[] fArray = new float[n];
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            fArray[i] = f = this.getFloatValueAt(string, i);
        }
        return fArray;
    }

    public String[] getAttributeAsStringArray(String string) throws ConfigurationException {
        Vector vector = this.getAttributeWithCheck(new KeyString(string));
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        for (Object e : vector) {
            try {
                if (e != null) {
                    stringArray[n2] = e.toString();
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            ++n2;
        }
        return stringArray;
    }

    public String getAttributeAsString(String string, String string2) throws ConfigurationException {
        Vector vector = this.getAttributeWithCheck(new KeyString(string));
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = true;
        for (Object e : vector) {
            block4: {
                block3: {
                    try {
                        if (bl) break block3;
                        stringBuffer.append(string2);
                        break block4;
                    }
                    catch (ConfigurationException configurationException) {
                        throw ConfigurationElement.a(configurationException);
                    }
                }
                bl = false;
            }
            stringBuffer.append(e);
        }
        return stringBuffer.toString();
    }

    public String getFirstAttributeValueAsString(String string) {
        block4: {
            Vector vector = this.getAttribute(string);
            try {
                try {
                    if (vector == null || vector.isEmpty()) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                return (String)vector.get(0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        return "";
    }

    public int getFirstAttributeValueAsPositiveInt(String string) throws ConfigurationException {
        block9: {
            Vector vector = this.getAttribute(string);
            try {
                if (vector == null || vector.isEmpty()) break block9;
            }
            catch (ClassCastException classCastException) {
                throw ConfigurationElement.a(classCastException);
            }
            Object e = vector.get(0);
            try {
                if (e instanceof Integer) {
                    return (Integer)e;
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            try {
                if (e instanceof String) {
                    return Integer.parseInt((String)e);
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            catch (ClassCastException classCastException) {
                throw new ConfigurationException(string + " value should be of type Integer: " + vector.get(0));
            }
        }
        return -1;
    }

    public double getFirstAttributeValueAsDouble(String string) throws ConfigurationException {
        block9: {
            Vector vector = this.getAttribute(string);
            try {
                if (vector == null || vector.isEmpty()) break block9;
            }
            catch (NumberFormatException numberFormatException) {
                throw ConfigurationElement.a(numberFormatException);
            }
            Object e = vector.get(0);
            try {
                if (e instanceof Double) {
                    return (Double)e;
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            try {
                if (e instanceof String) {
                    return Double.parseDouble((String)e);
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationException(string + " value should be of type Double: " + vector.get(0));
            }
        }
        return -1.0;
    }

    public boolean getFirstAttributeValueAsBoolean(String string) {
        block8: {
            Vector vector = this.getAttribute(string);
            try {
                if (vector == null || vector.isEmpty()) break block8;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
            Object e = vector.get(0);
            try {
                if (e instanceof Boolean) {
                    return (Boolean)e;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
            try {
                if (e instanceof String) {
                    return Boolean.parseBoolean((String)e);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        return false;
    }

    String getAttributeComment(String string) {
        return (String)this.attributeComments.get(new KeyString(string));
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    String[] getAttributeNamesInOriginalOrder() {
        String[] stringArray = null;
        Object[] objectArray = null;
        if (this.originalAttributeKeys.size() == this.attributes.size()) {
            objectArray = new String[this.originalAttributeKeys.size()];
            if (objectArray.length > 0) {
                objectArray = this.originalAttributeKeys.toArray();
            }
        } else {
            objectArray = this.attributes.keySet().toArray();
        }
        stringArray = new String[objectArray.length];
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        return stringArray;
    }

    public String[] getAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getAttributes();
        try {
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement().toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getSortedAttributeNames() {
        Object[] objectArray = this.getAttributeNames();
        Arrays.sort(objectArray);
        return objectArray;
    }

    String getBodyString() {
        return (String)this.body;
    }

    public String getBodyText() {
        try {
            if (this.body == null) {
                return (String)this.body;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        String string = (String)this.body;
        int n = string.indexOf("<");
        try {
            if (n == -1) {
                return string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        return string.substring(0, n);
    }

    public void resetRequestedAttributes() {
        block3: {
            block2: {
                try {
                    if (this.requestedAttributes != null) break block2;
                    this.requestedAttributes = new HashSet();
                    break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
            this.requestedAttributes.clear();
        }
    }

    private KeyString registerAttributeNameAndGetKey(String string) {
        KeyString keyString = new KeyString(string);
        try {
            if (string != null) {
                this.registerAttributeLowerCaseName(keyString.getLCaseKey());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        return keyString;
    }

    private void registerAttributeName(String string) {
        try {
            if (string != null) {
                this.registerAttributeLowerCaseName(string.toLowerCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
    }

    private void registerAttributeLowerCaseName(String string) {
        block4: {
            block5: {
                try {
                    try {
                        if (!this.requestedAttributesEnabled) break block4;
                        if (this.requestedAttributes != null) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                    this.requestedAttributes = new HashSet();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
            this.requestedAttributes.add(string);
        }
    }

    public Set<String> getUnrequestedAttributes() {
        return this.getUnrequestedAttributes(false, "");
    }

    public Set<String> getUnrequestedAttributes(boolean bl) {
        return this.getUnrequestedAttributes(bl, "");
    }

    private Set<String> getUnrequestedAttributes(boolean bl, String string) {
        try {
            if (this.requestedAttributes == null) {
                this.requestedAttributes = new HashSet();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<Serializable> iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            HashSet<String> hashSet2;
            String object2;
            block13: {
                block12: {
                    object2 = String.valueOf(iterator.next());
                    try {
                        try {
                            if (this.requestedAttributes.contains(object2.toLowerCase())) continue;
                            hashSet2 = hashSet;
                            if (!StringTool.isDefined(string)) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ConfigurationElement.a(illegalArgumentException);
                        }
                        object = string + "->";
                        break block13;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                }
                object = "";
            }
            hashSet2.add((String)object + object2);
        }
        if (bl) {
            for (ConfigurationElement configurationElement : this.children) {
                Object object;
                boolean bl2;
                ConfigurationElement configurationElement2;
                HashSet<String> hashSet3;
                try {
                    hashSet3 = hashSet;
                    configurationElement2 = configurationElement;
                    bl2 = true;
                    object = StringTool.isDefined(string) ? string + "->" : "";
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                hashSet3.addAll(configurationElement2.getUnrequestedAttributes(bl2, (String)object + configurationElement.getName()));
            }
        }
        return hashSet;
    }

    public boolean getBooleanValue(String string) throws ConfigurationException {
        return this.getBooleanValueAt(string, 0);
    }

    public boolean getBooleanValue(String string, boolean bl) throws ConfigurationException {
        KeyString keyString = new KeyString(string);
        try {
            if (this.checkForAttribute(keyString)) {
                return this.getBooleanValueAt(keyString, 0);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        return bl;
    }

    private boolean getBooleanValueAt(String string, int n) throws ConfigurationException {
        return this.getBooleanValueAt(new KeyString(string), n);
    }

    private boolean getBooleanValueAt(KeyString keyString, int n) throws ConfigurationException {
        Object object = this.getValueAt(keyString, n);
        String string = object.toString();
        try {
            if (string.equals("true")) {
                return true;
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        try {
            if (string.equals("false")) {
                return false;
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        throw new ConfigurationException("The required value for attribute '" + keyString + "' in '" + this.getPathToRoot() + "' is not boolean!");
    }

    public ConfigurationElement getChildForce(String string) throws ConfigurationException {
        ConfigurationElement configurationElement = this.getChild(string);
        try {
            if (configurationElement == null) {
                throw new ConfigurationException("Missing Configuration: " + string + " in path " + this.getPathToRoot());
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        return configurationElement;
    }

    public ConfigurationElement getChild(String string) {
        ConfigurationElement.assertNoWhitespaceInName(string);
        for (int i = 0; i < this.children.size(); ++i) {
            ConfigurationElement configurationElement = this.children.elementAt(i);
            try {
                try {
                    if (configurationElement == null || !string.equalsIgnoreCase(configurationElement.getName())) continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                return configurationElement;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean hasChild(ConfigurationElement configurationElement) {
        return this.children.contains(configurationElement);
    }

    public boolean hasChild(String string) {
        try {
            boolean bl;
            try {
                bl = this.getAllChildrenWithName(string).length > 0;
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            return bl;
        }
        catch (ConfigurationException configurationException) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean removeChildWithPath(String var1_1) throws ConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ConfigurationElement getChildWithPath(String var1_1) throws ConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ConfigurationElement getChildAt(int n) {
        ConfigurationElement configurationElement = new ConfigurationElement();
        try {
            if (n >= this.children.size()) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        configurationElement = this.children.elementAt(n);
        return configurationElement;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Deprecated
    public ConfigurationElement getChildWithNameAtIndex(String string, int n) throws ConfigurationException {
        ConfigurationElement[] configurationElementArray = this.getAllChildrenWithName(string);
        try {
            if (configurationElementArray.length == 0) {
                throw new ConfigurationException("There is no child with name '" + string + "'\n in '" + this.getPathToRoot() + "'!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        try {
            if (n >= configurationElementArray.length) {
                throw new ConfigurationException("The given index in '" + this.getPathToRoot() + "'\n is out of range ( " + n + ">=" + configurationElementArray.length + " )!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        return configurationElementArray[n];
    }

    public int getChildWithNameCount(String string) throws ConfigurationException {
        int n = 0;
        if (string != null) {
            for (ConfigurationElement configurationElement : this.children) {
                if (!string.equalsIgnoreCase(configurationElement.getName())) continue;
                ++n;
            }
        }
        return n;
    }

    public String getComment() {
        return this.comment;
    }

    public ConfigurationElement getConfiguration(String string) throws ConfigurationException {
        ConfigurationElement configurationElement;
        block7: {
            block5: {
                block6: {
                    configurationElement = null;
                    try {
                        try {
                            ConfigurationElement.assertNoWhitespaceInName(string);
                            if (string.indexOf(",") != -1) break block5;
                            if (!string.equalsIgnoreCase(this.getName())) break block6;
                        }
                        catch (ConfigurationException configurationException) {
                            throw ConfigurationElement.a(configurationException);
                        }
                        return this;
                    }
                    catch (ConfigurationException configurationException) {
                        throw ConfigurationElement.a(configurationException);
                    }
                }
                Enumeration<ConfigurationElement> enumeration = this.children();
                while (enumeration.hasMoreElements()) {
                    configurationElement = enumeration.nextElement().getConfiguration(string);
                    if (configurationElement == null) continue;
                    return configurationElement;
                }
                break block7;
            }
            configurationElement = this.getConfigurationAsChildOf(string.substring(0, string.indexOf(",")), string.substring(string.indexOf(",") + 1, string.length()));
        }
        return configurationElement;
    }

    private ConfigurationElement getConfigurationAsChildOf(String string, String string2) throws ConfigurationException {
        ConfigurationElement configurationElement = this.getConfiguration(string).getConfiguration(string2);
        return configurationElement;
    }

    public String getDefinitionID() {
        return this.definitionID;
    }

    public String getConfigurationVersion() {
        return this.configurationVersion;
    }

    public float getConfigurationVersionFloat() {
        float f = 0.0f;
        try {
            if (!StringTool.isDefined(this.configurationVersion)) {
                return f;
            }
        }
        catch (ParseException parseException) {
            throw ConfigurationElement.a(parseException);
        }
        try {
            DecimalFormat decimalFormat = new DecimalFormat("0.#");
            f = decimalFormat.parse(this.configurationVersion).floatValue();
        }
        catch (ParseException parseException) {
            logger.warn("Cannot convert version number " + this.configurationVersion + " to float." + parseException.getMessage());
        }
        return f;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        ConfigurationElement configurationElement = (ConfigurationElement)treeNode;
        ConfigurationElement configurationElement2 = (ConfigurationElement)configurationElement.getParent();
        int n = 0;
        while (true) {
            block5: {
                try {
                    try {
                        if (n >= configurationElement2.getChildCount()) break;
                        if (configurationElement2.getChildAt(n) != configurationElement) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                    return n;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
            ++n;
        }
        return -1;
    }

    public int getIntValue(String string) throws ConfigurationException {
        return this.getIntValueAt(string, 0);
    }

    public int getIntValueMinMaxDefault(String string, int n, int n2, int n3) throws ConfigurationException {
        int n4;
        block14: {
            int n5;
            block13: {
                try {
                    if (n2 < n) {
                        throw new ConfigurationException("min (" + n + ") > max (" + n2 + ") for property " + string);
                    }
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
                try {
                    if (n3 > n2) {
                        throw new ConfigurationException("default_value (" + n3 + ") > max (" + n2 + ") for property " + string);
                    }
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
                try {
                    if (n3 < n) {
                        throw new ConfigurationException("default_value (" + n3 + ") < min (" + n + ") for property " + string);
                    }
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
                n5 = this.getIntValue(string, n3);
                try {
                    if (n5 >= n) break block13;
                    n4 = n;
                    break block14;
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
            }
            try {
                n4 = n5 > n2 ? n2 : n5;
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
        }
        return n4;
    }

    public int getIntValueMinMax(String string, int n, int n2) throws ConfigurationException {
        try {
            if (n2 < n) {
                throw new ConfigurationException("min (" + n + ") > max (" + n2 + ") for property " + string);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        int n3 = this.getIntValue(string);
        try {
            if (n3 > n2) {
                throw new ConfigurationException("value (" + n3 + ") > max (" + n2 + ") for property " + string);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        try {
            if (n3 < n) {
                throw new ConfigurationException("value (" + n3 + ") < min (" + n + ") for property " + string);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        return n3;
    }

    public int getIntValue(String string, int n) throws ConfigurationException {
        KeyString keyString = new KeyString(string);
        try {
            if (this.checkForAttribute(keyString)) {
                return this.getIntValueAt(keyString, 0);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        return n;
    }

    public int getIntValueAt(String string, int n) throws ConfigurationException {
        return this.getIntValueAt(new KeyString(string), n);
    }

    private int getIntValueAt(KeyString keyString, int n) throws ConfigurationException {
        Object object = this.getValueAt(keyString, n);
        try {
            return Integer.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("The attribute '" + keyString.toString() + "' in '" + this.getPathToRoot() + "' has no valid integer value at index #" + n);
        }
    }

    private long getLongValueAt(String string, int n) throws ConfigurationException {
        return this.getLongValueAt(new KeyString(string), n);
    }

    private long getLongValueAt(KeyString keyString, int n) throws ConfigurationException {
        Object object = this.getValueAt(keyString, n);
        try {
            return Long.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("The attribute '" + keyString + "' in '" + this.getPathToRoot() + "' has no valid long value at index #" + n);
        }
    }

    public long getLongValue(String string) throws ConfigurationException {
        return this.getLongValueAt(string, 0);
    }

    public long getLongValue(String string, long l) throws ConfigurationException {
        KeyString keyString = new KeyString(string);
        try {
            if (this.checkForAttribute(keyString)) {
                return this.getLongValueAt(keyString, 0);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        return l;
    }

    public float getFloatValue(String string) throws ConfigurationException {
        return this.getFloatValueAt(string, 0);
    }

    public float getFloatValue(String string, float f) throws ConfigurationException {
        KeyString keyString = new KeyString(string);
        try {
            if (this.checkForAttribute(keyString)) {
                return this.getFloatValueAt(keyString, 0);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        return f;
    }

    private float getFloatValueAt(String string, int n) throws ConfigurationException {
        return this.getFloatValueAt(new KeyString(string), n);
    }

    private float getFloatValueAt(KeyString keyString, int n) throws ConfigurationException {
        Object object = this.getValueAt(keyString, n);
        try {
            return Float.valueOf(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("The attribute '" + keyString + "' in '" + this.getPathToRoot() + "' has no valid float value at index #" + n);
        }
    }

    public double getDoubleValue(String string) throws ConfigurationException {
        return this.getDoubleValueAt(string, 0);
    }

    public double getDoubleValue(String string, double d) throws ConfigurationException {
        KeyString keyString = new KeyString(string);
        try {
            if (this.checkForAttribute(keyString)) {
                return this.getDoubleValueAt(keyString, 0);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        return d;
    }

    private double getDoubleValueAt(String string, int n) throws ConfigurationException {
        return this.getDoubleValueAt(new KeyString(string), n);
    }

    private double getDoubleValueAt(KeyString keyString, int n) throws ConfigurationException {
        Object object = this.getValueAt(keyString, n);
        try {
            return Double.valueOf(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("The attribute '" + keyString.toString() + "' in '" + this.getPathToRoot() + "' has no valid double value at index #" + n);
        }
    }

    public String getName() {
        this.registerAttributeName("name");
        return this.configurationName;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public String getPathToRoot() {
        ConfigurationElement configurationElement = this;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.configurationName);
        while (configurationElement.getParent() != null) {
            configurationElement = (ConfigurationElement)configurationElement.getParent();
            stringBuffer.insert(0, ',');
            stringBuffer.insert(0, configurationElement.configurationName);
        }
        return stringBuffer.toString();
    }

    public ConfigurationElement getRoot() {
        ConfigurationElement configurationElement = this;
        while (configurationElement.getParent() != null) {
            configurationElement = (ConfigurationElement)configurationElement.getParent();
        }
        return configurationElement;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char getCharFromHexValue(String string) throws ConfigurationException {
        String string2;
        block6: {
            string2 = this.getStringValueAt(string, 0);
            if (string2 == null) throw new ConfigurationException("Illegal value for attribute: " + string + ": " + string2 + ". Configuration: " + this.getPathToRoot());
            try {
                if (string2.length() == 4) break block6;
                throw new ConfigurationException("Illegal value for attribute: " + string + ": " + string2 + ". Configuration: " + this.getPathToRoot());
                catch (Exception exception) {
                    throw ConfigurationElement.a(exception);
                }
            }
            catch (Exception exception) {
                throw ConfigurationElement.a(exception);
            }
        }
        try {
            return (char)Byte.decode(string2).byteValue();
        }
        catch (Exception exception) {
            throw new ConfigurationException("Illegal value for attribute: " + string + ": " + string2 + ". Configuration: " + this.getPathToRoot(), exception);
        }
    }

    public String getStringValue(String string) throws ConfigurationException {
        return this.getStringValueAt(string, 0);
    }

    public String getStringValue(String string, String string2) throws ConfigurationException {
        KeyString keyString = new KeyString(string);
        try {
            if (this.checkForAttribute(keyString)) {
                return this.getStringValueAt(keyString, 0);
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.registerAttributeLowerCaseName(keyString.getLCaseKey());
        return string2;
    }

    public String getStringValueAt(String string, int n) throws ConfigurationException {
        return this.getStringValueAt(new KeyString(string), n);
    }

    private final String getStringValueAt(KeyString keyString, int n) throws ConfigurationException {
        Object object = this.getValueAt(keyString, n);
        try {
            if (object != null) {
                return object.toString();
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        return "";
    }

    public int getValueCount(String string) throws ConfigurationException {
        Vector<?> vector = this.attributes.get(new KeyString(string));
        try {
            if (vector == null) {
                throw new ConfigurationException("The required attribute '" + string + "' is not found in '" + this.getName() + "'!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        return vector.size();
    }

    private Object getValueAt(KeyString keyString, int n) throws ConfigurationException {
        Vector vector = this.getAttributeWithCheck(keyString);
        if (vector.size() <= n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The index given for attribute '");
            stringBuffer.append(keyString.toString());
            stringBuffer.append("' in '");
            stringBuffer.append(this.getPathToRoot());
            stringBuffer.append("' is out of range!");
            throw new ConfigurationException(stringBuffer.toString());
        }
        return vector.elementAt(n);
    }

    private final boolean isExisting(ConfigurationElement configurationElement) {
        return this.children.contains(configurationElement);
    }

    public boolean isExisting(String string) {
        ConfigurationElement.assertNoWhitespaceInName(string);
        for (int i = 0; i < this.children.size(); ++i) {
            ConfigurationElement configurationElement = this.children.elementAt(i);
            try {
                if (!string.equalsIgnoreCase(configurationElement.getName())) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        try {
            if (this.children.size() > 0) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        return true;
    }

    public void removeAttribute(String string) {
        ConfigurationElement.assertNoWhitespaceInName(string);
        KeyString keyString = new KeyString(string);
        this.attributes.remove(keyString);
        this.originalAttributeKeys.remove(keyString);
    }

    public boolean isAttributeExisting(String string) {
        ConfigurationElement.assertNoWhitespaceInName(string);
        KeyString keyString = new KeyString(string);
        return this.attributes.containsKey(keyString);
    }

    public void removeChild(String string) throws ConfigurationException {
        ConfigurationElement.assertNoWhitespaceInName(string);
        boolean bl = false;
        int n = 0;
        while (true) {
            block6: {
                try {
                    if (n >= this.children.size()) break;
                    if (!this.children.elementAt(n).getName().equalsIgnoreCase(string)) break block6;
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
                this.children.removeElementAt(n);
                bl = true;
                break;
            }
            ++n;
        }
        try {
            if (!bl) {
                throw new ConfigurationException("The child '" + string + "' could not be removed\nfrom '" + this.getName() + "' because it was not found!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
    }

    public void removeAllChild() {
        this.children.clear();
    }

    public void removeChild(ConfigurationElement configurationElement) throws ConfigurationException {
        try {
            if (!this.children.remove(configurationElement)) {
                throw new ConfigurationException("The child '" + configurationElement.getName() + "' could not be removed\from '" + this.getName() + "' because it was not found!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
    }

    void removeChild(int n) throws ConfigurationException {
        try {
            if (n >= this.children.size()) {
                throw new ConfigurationException("The child at position " + n + " can not be removed. Illegal position!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        this.children.remove(n);
    }

    public void setBody(Object object) {
        this.body = object;
    }

    public void addBody(Object object) {
        try {
            this.body = this.body == null ? object : this.body + object.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDefinitionID(String string) {
        this.definitionID = string;
    }

    public void setConfigurationVersion(String string) {
        this.configurationVersion = string;
    }

    public void setName(String string) {
        this.configurationName = string;
    }

    public void setParent(ConfigurationElement configurationElement) {
        this.parent = configurationElement;
    }

    public void setValueAtIndex(String string, String string2, int n) throws ConfigurationException {
        Vector vector = this.getAttribute_(string);
        try {
            if (vector == null) {
                throw new ConfigurationException("The attribute '" + string + "' was not found in '" + this.configurationName + "'!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        try {
            if (n < 0) {
                throw new ConfigurationException("The given index for attribute '" + string + "' is\nout of range ( " + n + " < 0 ). Value was not set!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        try {
            if (n >= vector.size()) {
                throw new ConfigurationException("The given index for attribute '" + string + "' is\nout of range ( " + n + " < 0 ). Value was not set!");
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        vector.setElementAt(this.removeIllegalCharacters(string2), n);
    }

    public String toString() {
        return this.toString(false, true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        return this.toString(bl, bl2, false);
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        String string;
        Object object;
        Hashtable<KeyString, Vector<?>> hashtable;
        String string2;
        String string3;
        block32: {
            block31: {
                block30: {
                    block29: {
                        block22: {
                            String string4;
                            Object object2;
                            String string5;
                            String string6;
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            try {
                                                block23: {
                                                    try {
                                                        try {
                                                            try {
                                                                if (this.checkForAttribute("name")) break block22;
                                                                string6 = this.getName();
                                                                string5 = this.getAttributesString(bl3);
                                                                if (bl) break block23;
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw ConfigurationElement.a(illegalArgumentException);
                                                            }
                                                            if (this.getAllChildren() == null) break block23;
                                                        }
                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                            throw ConfigurationElement.a(illegalArgumentException);
                                                        }
                                                        if (this.getAllChildren().size() != 0) break block24;
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                        throw ConfigurationElement.a(illegalArgumentException);
                                                    }
                                                }
                                                object2 = "";
                                                break block25;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw ConfigurationElement.a(illegalArgumentException);
                                            }
                                        }
                                        object2 = " Children: " + this.getAllChildren();
                                    }
                                    try {
                                        try {
                                            if (!bl2 && this.getComment() != null) break block26;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw ConfigurationElement.a(illegalArgumentException);
                                        }
                                        string4 = "";
                                        break block27;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw ConfigurationElement.a(illegalArgumentException);
                                    }
                                }
                                string4 = this.getComment();
                            }
                            return string6 + " Attributes: " + string5 + (String)object2 + string4;
                        }
                        try {
                            block28: {
                                try {
                                    try {
                                        string3 = this.getName();
                                        string2 = (String)this.getAttribute_("name").elementAt(0);
                                        hashtable = this.attributes;
                                        if (bl || this.getAllChildren() == null) break block28;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw ConfigurationElement.a(illegalArgumentException);
                                    }
                                    if (this.getAllChildren().size() != 0) break block29;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw ConfigurationElement.a(illegalArgumentException);
                                }
                            }
                            object = "";
                            break block30;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ConfigurationElement.a(illegalArgumentException);
                        }
                    }
                    object = " Children: " + this.getAllChildren();
                }
                try {
                    try {
                        if (!bl2 && this.getComment() != null) break block31;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                    string = "";
                    break block32;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
            string = this.getComment();
        }
        return string3 + ": " + string2 + " Attributes: " + hashtable + (String)object + string;
    }

    private String getAttributesString(boolean bl) {
        try {
            if (!bl) {
                return String.valueOf(this.attributes);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("{");
        ArrayList<KeyString> arrayList = new ArrayList<KeyString>(this.attributes.keySet());
        Collections.sort(arrayList, new KeyStringComparator());
        for (KeyString keyString : arrayList) {
            stringBuilder.append(keyString).append("=").append(this.attributes.get(keyString)).append(", ");
        }
        try {
            if (arrayList.size() > 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    String getBodyComment() {
        return this.bodyComment;
    }

    void setBodyComment(String string) {
        this.bodyComment = string;
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, "name");
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, boolean bl2) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, "name", bl2);
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, boolean bl2, String[] stringArray) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, new String[]{"name"}, true, bl2, stringArray);
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, String string) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, new String[]{string}, true, false);
    }

    private boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, String string, boolean bl2) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, new String[]{string}, true, bl2);
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, String[] stringArray, boolean bl2) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, stringArray, bl2, false);
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, String[] stringArray, boolean bl2, boolean bl3) throws ConfigurationException {
        return this.mergeConfiguration(configurationElement, bl, stringArray, bl2, bl3, null);
    }

    public boolean mergeConfiguration(ConfigurationElement configurationElement, boolean bl, String[] stringArray, boolean bl2, boolean bl3, String[] stringArray2) throws ConfigurationException {
        return this._mergeConfiguration(configurationElement, bl, stringArray, bl2, bl3, stringArray2, 0, this.getMaxMergeDepth());
    }

    private boolean _mergeConfiguration(ConfigurationElement configurationElement, boolean bl, String[] stringArray, boolean bl2, boolean bl3, String[] stringArray2, int n, int n2) throws ConfigurationException {
        Object object;
        boolean bl4 = false;
        try {
            if (configurationElement == null) {
                return bl4;
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        try {
            if (++n > n2) {
                return bl4;
            }
        }
        catch (ConfigurationException configurationException) {
            throw ConfigurationElement.a(configurationException);
        }
        Set<Map.Entry<KeyString, Vector<?>>> set = configurationElement.attributes.entrySet();
        for (Map.Entry<KeyString, Vector<?>> entry : set) {
            KeyString keyString = entry.getKey();
            object = keyString.key;
            try {
                if (!bl && this.checkForAttribute((String)object)) continue;
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            Vector<?> vector = entry.getValue();
            this.addAttribute((String)object, vector);
            bl4 = true;
        }
        Vector<ConfigurationElement> vector = configurationElement.getAllChildren();
        for (int i = 0; i < vector.size(); ++i) {
            block44: {
                block43: {
                    block40: {
                        boolean bl5;
                        block42: {
                            block41: {
                                int n3;
                                boolean bl6 = false;
                                object = (ConfigurationElement)vector.get(i);
                                boolean bl7 = false;
                                if (stringArray2 != null) {
                                    int n4 = 0;
                                    while (true) {
                                        block34: {
                                            try {
                                                if (n4 >= stringArray2.length) break;
                                                if (!((ConfigurationElement)object).getName().equalsIgnoreCase(stringArray2[n4])) break block34;
                                            }
                                            catch (ConfigurationException configurationException) {
                                                throw ConfigurationElement.a(configurationException);
                                            }
                                            bl7 = true;
                                            break;
                                        }
                                        ++n4;
                                    }
                                }
                                if (bl7) continue;
                                ConfigurationElement[] configurationElementArray = this.getAllChildrenWithName(((ConfigurationElement)object).getName());
                                if (configurationElementArray.length > 1) {
                                    block39: {
                                        block38: {
                                            n3 = 0;
                                            while (true) {
                                                block35: {
                                                    boolean bl8;
                                                    block37: {
                                                        block36: {
                                                            try {
                                                                if (n3 >= configurationElementArray.length) break;
                                                                if (!this.areSameChilds(configurationElementArray[n3], (ConfigurationElement)object, stringArray, bl2)) break block35;
                                                            }
                                                            catch (ConfigurationException configurationException) {
                                                                throw ConfigurationElement.a(configurationException);
                                                            }
                                                            boolean bl9 = configurationElementArray[n3]._mergeConfiguration((ConfigurationElement)object, bl, stringArray, bl2, bl3, stringArray2, n, n2);
                                                            try {
                                                                try {
                                                                    if (!bl4 && !bl9) break block36;
                                                                }
                                                                catch (ConfigurationException configurationException) {
                                                                    throw ConfigurationElement.a(configurationException);
                                                                }
                                                                bl8 = true;
                                                                break block37;
                                                            }
                                                            catch (ConfigurationException configurationException) {
                                                                throw ConfigurationElement.a(configurationException);
                                                            }
                                                        }
                                                        bl8 = false;
                                                    }
                                                    bl4 = bl8;
                                                    bl6 = true;
                                                }
                                                ++n3;
                                            }
                                            try {
                                                try {
                                                    if (bl6) continue;
                                                    if (!bl3) break block38;
                                                }
                                                catch (ConfigurationException configurationException) {
                                                    throw ConfigurationElement.a(configurationException);
                                                }
                                                this.addChildSetDisabled((ConfigurationElement)object);
                                                break block39;
                                            }
                                            catch (ConfigurationException configurationException) {
                                                throw ConfigurationElement.a(configurationException);
                                            }
                                        }
                                        this.addChild((ConfigurationElement)object);
                                    }
                                    bl4 = true;
                                    continue;
                                }
                                try {
                                    if (configurationElementArray.length <= 0 || configurationElementArray[0] == null) break block40;
                                }
                                catch (ConfigurationException configurationException) {
                                    throw ConfigurationElement.a(configurationException);
                                }
                                n3 = configurationElementArray[0]._mergeConfiguration((ConfigurationElement)object, bl, stringArray, bl2, bl3, stringArray2, n, n2) ? 1 : 0;
                                try {
                                    try {
                                        if (!bl4 && n3 == 0) break block41;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    bl5 = true;
                                    break block42;
                                }
                                catch (ConfigurationException configurationException) {
                                    throw ConfigurationElement.a(configurationException);
                                }
                            }
                            bl5 = false;
                        }
                        bl4 = bl5;
                        continue;
                    }
                    try {
                        if (!bl3) break block43;
                        this.addChildSetDisabled((ConfigurationElement)object);
                        break block44;
                    }
                    catch (ConfigurationException configurationException) {
                        throw ConfigurationElement.a(configurationException);
                    }
                }
                this.addChild((ConfigurationElement)object);
            }
            bl4 = true;
        }
        return bl4;
    }

    boolean containsNonASCIIChars() {
        return this._containsNonASCIIChars(this);
    }

    private boolean _containsNonASCIIChars(ConfigurationElement configurationElement) {
        block22: {
            Object object;
            try {
                if (StringTool.containsNonASCIIChars(configurationElement.getName())) {
                    return true;
                }
            }
            catch (Exception exception) {
                throw ConfigurationElement.a(exception);
            }
            Enumeration enumeration = configurationElement.getAttributes();
            block16: while (enumeration.hasMoreElements()) {
                object = ((KeyString)enumeration.nextElement()).toString();
                try {
                    if (StringTool.containsNonASCIIChars((String)object)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    throw ConfigurationElement.a(exception);
                }
                String[] stringArray = new String[]{};
                try {
                    stringArray = configurationElement.getAttributeAsStringArray((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n = 0;
                while (true) {
                    block21: {
                        try {
                            try {
                                if (n >= stringArray.length) continue block16;
                                if (!StringTool.containsNonASCIIChars(stringArray[n])) break block21;
                            }
                            catch (Exception exception) {
                                throw ConfigurationElement.a(exception);
                            }
                            return true;
                        }
                        catch (Exception exception) {
                            throw ConfigurationElement.a(exception);
                        }
                    }
                    ++n;
                }
            }
            object = configurationElement.getAllChildren();
            try {
                if (object == null || ((Vector)object).size() <= 0) break block22;
            }
            catch (Exception exception) {
                throw ConfigurationElement.a(exception);
            }
            int n = 0;
            while (true) {
                block23: {
                    try {
                        try {
                            if (n >= ((Vector)object).size()) break;
                            if (!this._containsNonASCIIChars((ConfigurationElement)((Vector)object).get(n))) break block23;
                        }
                        catch (Exception exception) {
                            throw ConfigurationElement.a(exception);
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        throw ConfigurationElement.a(exception);
                    }
                }
                ++n;
            }
        }
        return false;
    }

    public void correctConfigurationNames(Map map) {
        String string;
        String string2;
        KeyString keyString;
        block23: {
            block22: {
                try {
                    try {
                        if (map != null && !map.isEmpty()) break block22;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
            }
            Object v = map.get(this.getName());
            try {
                if (v != null) {
                    this.setName((String)v);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
            Vector<ConfigurationElement> vector = this.getAllChildren();
            try {
                if (vector == null || vector.size() <= 0) break block23;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
            try {
                for (int i = 0; i < vector.size(); ++i) {
                    vector.get(i).correctConfigurationNames(map);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        Enumeration<KeyString> enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            keyString = enumeration.nextElement();
            string2 = keyString.toString();
            string = (String)map.get(string2);
            try {
                try {
                    if (string == null || this.checkHashtableForKeyString(this.attributes, string)) continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                this.attributes.put(new KeyString(string), this.attributes.get(keyString));
                this.originalAttributeKeys.add(string);
                this.attributes.remove(keyString);
                this.originalAttributeKeys.remove(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        enumeration = this.attributeComments.keys();
        while (enumeration.hasMoreElements()) {
            keyString = enumeration.nextElement();
            string2 = keyString.toString();
            string = (String)map.get(string2);
            try {
                try {
                    if (string == null || this.checkHashtableForKeyString(this.attributeComments, string)) continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                this.attributeComments.put(new KeyString(string), this.attributeComments.get(keyString));
                this.attributeComments.remove(keyString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
    }

    private boolean checkHashtableForKeyString(Hashtable hashtable, String string) {
        String string2 = string.toLowerCase();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            if (!((KeyString)enumeration.nextElement()).getLCaseKey().equals(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean areSameChilds(ConfigurationElement configurationElement, ConfigurationElement configurationElement2, String[] stringArray, boolean bl) throws ConfigurationException {
        block54: {
            try {
                if (!configurationElement.getName().toLowerCase().equals(configurationElement2.getName().toLowerCase())) {
                    return false;
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            try {
                try {
                    if (stringArray != null && stringArray.length >= 1) break block54;
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
                throw new ConfigurationException("Invalid id attribute specified (null)");
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
        }
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            block58: {
                Object object;
                Object object2;
                block56: {
                    block57: {
                        object2 = "";
                        object = "";
                        if (stringArray[i].indexOf(38) != -1) {
                            var9_11 = stringArray[i];
                            while (!var9_11.equals("")) {
                                String string;
                                String string2;
                                String string3;
                                String string4;
                                String string5;
                                int n;
                                block55: {
                                    int n2;
                                    int n3;
                                    String string6;
                                    ConfigurationElement configurationElement3;
                                    int n4;
                                    int n5;
                                    String string7;
                                    ConfigurationElement configurationElement4;
                                    n = var9_11.indexOf(38);
                                    try {
                                        configurationElement4 = configurationElement;
                                        string7 = var9_11;
                                        n5 = 0;
                                        n4 = n == -1 ? var9_11.length() : n;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    var11_14 = configurationElement4.getStringValue(string7.substring(n5, n4), "");
                                    try {
                                        configurationElement3 = configurationElement2;
                                        string6 = var9_11;
                                        n3 = 0;
                                        n2 = n == -1 ? var9_11.length() : n;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    string5 = configurationElement3.getStringValue(string6.substring(n3, n2), "");
                                    try {
                                        if (!var11_14.equals("") && !string5.equals("")) break block55;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    object2 = null;
                                    object = null;
                                    break block56;
                                }
                                try {
                                    string4 = object2;
                                    string3 = ((String)object2).equals("") ? "" : "&";
                                }
                                catch (ConfigurationException configurationException) {
                                    throw ConfigurationElement.a(configurationException);
                                }
                                object2 = string4 + string3 + (String)var11_14;
                                try {
                                    string2 = object;
                                    string = ((String)object).equals("") ? "" : "&";
                                }
                                catch (ConfigurationException configurationException) {
                                    throw ConfigurationElement.a(configurationException);
                                }
                                object = string2 + string + string5;
                                if (n == -1) {
                                    var9_11 = "";
                                    continue;
                                }
                                var9_11 = var9_11.substring(n + 1);
                            }
                        } else {
                            String string;
                            int n;
                            try {
                                try {
                                    if (stringArray[i].indexOf(123) == -1 || stringArray[i].indexOf(125) == -1) break block57;
                                }
                                catch (ConfigurationException configurationException) {
                                    throw ConfigurationElement.a(configurationException);
                                }
                                if (stringArray[i].indexOf("->") == -1) break block57;
                            }
                            catch (ConfigurationException configurationException) {
                                throw ConfigurationElement.a(configurationException);
                            }
                            var9_11 = stringArray[i].substring(stringArray[i].indexOf(123) + 1, stringArray[i].indexOf("->"));
                            String string8 = stringArray[i].substring(stringArray[i].indexOf("->") + 2, stringArray[i].indexOf(125));
                            var11_14 = configurationElement.getAllChildrenWithName(var9_11);
                            if (var11_14 != null) {
                                for (n = 0; n < var11_14.length; ++n) {
                                    String string9;
                                    String string10;
                                    Object object3;
                                    string = var11_14[n].getAttributeAsString(string8, ",");
                                    try {
                                        object3 = object2;
                                        string10 = ((String)object2).equals("") ? "" : "&";
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    try {
                                        string9 = string == null ? "" : string;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    object2 = (String)object3 + string10 + string9;
                                }
                            }
                            if ((var11_14 = configurationElement2.getAllChildrenWithName(var9_11)) != null) {
                                for (n = 0; n < var11_14.length; ++n) {
                                    String string11;
                                    String string12;
                                    Object object4;
                                    string = var11_14[n].getAttributeAsString(string8, ",");
                                    try {
                                        object4 = object;
                                        string12 = ((String)object).equals("") ? "" : "&";
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    try {
                                        string11 = string == null ? "" : string;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw ConfigurationElement.a(configurationException);
                                    }
                                    object = (String)object4 + string12 + string11;
                                }
                            }
                        }
                        break block56;
                    }
                    object2 = configurationElement.getStringValue(stringArray[i], null);
                    object = configurationElement2.getStringValue(stringArray[i], null);
                }
                try {
                    try {
                        try {
                            try {
                                try {
                                    if (object2 == null || ((String)object2).equals("")) continue;
                                }
                                catch (ConfigurationException configurationException) {
                                    throw ConfigurationElement.a(configurationException);
                                }
                                if (object == null) continue;
                            }
                            catch (ConfigurationException configurationException) {
                                throw ConfigurationElement.a(configurationException);
                            }
                            if (((String)object).equals("")) continue;
                        }
                        catch (ConfigurationException configurationException) {
                            throw ConfigurationElement.a(configurationException);
                        }
                        if (!((String)object2).toLowerCase().equals(((String)object).toLowerCase())) break block58;
                    }
                    catch (ConfigurationException configurationException) {
                        throw ConfigurationElement.a(configurationException);
                    }
                    return true;
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
            }
            if (bl2) continue;
            bl2 = true;
            try {
                if (!bl) continue;
                break;
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
        }
        if (!bl2) {
            StringBuffer stringBuffer = new StringBuffer("[" + stringArray[0]);
            try {
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuffer.append(", " + stringArray[i]);
                }
            }
            catch (ConfigurationException configurationException) {
                throw ConfigurationElement.a(configurationException);
            }
            throw new ConfigurationException("Can't merge configuration. Ambiguous child, because no identifier attribute was found. " + configurationElement.getPathToRoot() + " " + stringBuffer.toString() + "]");
        }
        return false;
    }

    boolean isUseCRBetweenAttributes() {
        return this.useCRBetweenAttributes;
    }

    public void setUseCRBetweenAttributes(boolean bl) {
        this.useCRBetweenAttributes = bl;
    }

    int getMaxAttributeLineLength() {
        return this.maxAttributeLineLength;
    }

    public void setMaxAttributeLineLength(int n) {
        this.maxAttributeLineLength = n;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    private int getMaxMergeDepth() {
        return this.maxMergeDepth;
    }

    public void setMaxMergeDepth(int n) {
        this.maxMergeDepth = n;
    }

    void removeTransientChilds() {
        Vector<ConfigurationElement> vector = this.getAllChildren();
        for (int i = 0; i < vector.size(); ++i) {
            ConfigurationElement configurationElement = vector.get(i);
            try {
                try {
                    if (configurationElement.getBooleanValue(TRANSIENT_KEY, false)) {
                        this.removeChild(configurationElement);
                        continue;
                    }
                }
                catch (ConfigurationException configurationException) {
                    throw ConfigurationElement.a(configurationException);
                }
                configurationElement.removeTransientChilds();
                continue;
            }
            catch (ConfigurationException configurationException) {
                configurationElement.removeTransientChilds();
            }
        }
    }

    private String removeIllegalCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string == null) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationElement.a(illegalArgumentException);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            try {
                try {
                    try {
                        if (c < ' ' || c == '\u007f') continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ConfigurationElement.a(illegalArgumentException);
                    }
                    if (c == '\u00ff') continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ConfigurationElement.a(illegalArgumentException);
                }
                stringBuffer.append(c);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ConfigurationElement.a(illegalArgumentException);
            }
        }
        return stringBuffer.toString();
    }

    public final void setRequestedAttributesEnabled(boolean bl) {
        this.requestedAttributesEnabled = bl;
        if (!this.children.isEmpty()) {
            for (ConfigurationElement configurationElement : this.children) {
                configurationElement.setRequestedAttributesEnabled(bl);
            }
        }
    }

    public void clear() {
        this.attributes.clear();
        this.originalAttributeKeys.clear();
        this.requestedAttributes.clear();
        this.children.clear();
        this.body = null;
        this.bodyComment = null;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    private class KeyString
    implements Serializable {
        private static final long serialVersionUID = -7542367058618325393L;
        private final String key;
        private transient String lowerCaseKey;

        private KeyString(String string) {
            this.key = string;
            this.lowerCaseKey = string.toLowerCase();
        }

        public String getLCaseKey() {
            if (this.lowerCaseKey == null) {
                this.lowerCaseKey = this.key.toLowerCase();
            }
            return this.lowerCaseKey;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof KeyString) {
                return this.getLCaseKey().equals(((KeyString)object).getLCaseKey());
            }
            if (object instanceof String) {
                return this.getLCaseKey().equals(((String)object).toLowerCase());
            }
            return false;
        }

        public final int hashCode() {
            return this.getLCaseKey().hashCode();
        }

        public final String toString() {
            return this.key;
        }
    }

    private class KeyStringComparator
    implements Comparator<KeyString> {
        private KeyStringComparator() {
        }

        @Override
        public int compare(KeyString keyString, KeyString keyString2) {
            if (keyString == keyString2) {
                return 0;
            }
            if (keyString == null) {
                return -1;
            }
            if (keyString2 == null) {
                return 1;
            }
            return keyString.toString().compareTo(keyString2.toString());
        }
    }
}

