/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicommail.data;

import com.visustt.dicommail.data.ad;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;

public class MailSSLCertificateData
implements Serializable {
    private static final long serialVersionUID = 2824025363669109672L;
    private static final int UNTRUSTED = 0;
    private static final int TRUSTED = 1;
    private final X509Certificate certificate;
    private final String issuerCommonName;
    private final String subjectCommonName;
    private final String alias;
    private int state = 0;

    public MailSSLCertificateData(X509Certificate x509Certificate, String string) {
        this.certificate = x509Certificate;
        this.alias = string;
        ad ad2 = new ad(x509Certificate.getIssuerX500Principal());
        this.issuerCommonName = ad2.aa();
        ad2 = new ad(x509Certificate.getSubjectX500Principal());
        this.subjectCommonName = ad2.aa();
    }

    public final X509Certificate getCertificate() {
        return this.certificate;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public final String getSubjectCommonName() {
        return this.subjectCommonName;
    }

    public final boolean isTrusted() {
        return (this.state & 1) == 1;
    }

    public final void setTrusted(boolean bl) {
        if (bl) {
            if (!this.isTrusted()) {
                ++this.state;
            }
        } else if (this.isTrusted()) {
            --this.state;
        }
    }

    public final boolean isExpired() {
        Date date = this.certificate.getNotAfter();
        return System.currentTimeMillis() > date.getTime();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.certificate == null ? 0 : this.certificate.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MailSSLCertificateData)) {
            return false;
        }
        MailSSLCertificateData mailSSLCertificateData = (MailSSLCertificateData)object;
        return !(this.certificate == null ? mailSSLCertificateData.certificate != null : !this.certificate.equals(mailSSLCertificateData.certificate));
    }
}

