/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.util;

import java.io.Serializable;
import java.util.HashSet;

public class DicomWindow
implements Serializable {
    public static final String ATTR_DICOMWINDOW_FROM_CAPTURE = "fromCapture";
    public static final String ATTR_DICOMWINDOW_FROM_SERIES = "fromSeries";
    private static final long serialVersionUID = 2813837962990544260L;
    private double width;
    private double center;
    private String explanation = null;
    private boolean isOffsetWindow = false;
    private boolean isWindowRange = false;
    private boolean isOptimalWindow = false;
    private boolean isUserPreset = false;
    private HashSet attributes = new HashSet();

    public DicomWindow() {
        this(-1.0, -1.0, null);
    }

    public DicomWindow(DicomWindow dicomWindow) {
        this(dicomWindow.center, dicomWindow.width, dicomWindow.explanation);
    }

    public DicomWindow(double d, double d2) {
        this.center = d;
        this.width = d2;
        this.explanation = null;
    }

    public DicomWindow(double d, double d2, String string) {
        this.center = d;
        this.width = d2;
        this.explanation = string;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String string) {
        this.explanation = string;
    }

    public boolean isOffsetWindow() {
        return this.isOffsetWindow;
    }

    public void setOffsetWindow(boolean bl) {
        this.isOffsetWindow = bl;
    }

    public boolean isUserPreset() {
        return this.isUserPreset;
    }

    public void setUserPreset(boolean bl) {
        this.isUserPreset = bl;
    }

    public boolean isWindowRange() {
        return this.isWindowRange;
    }

    public void setWindowRange(boolean bl) {
        this.isWindowRange = bl;
    }

    public boolean isOptimalWindow() {
        return this.isOptimalWindow;
    }

    public void setOptimalWindow(boolean bl) {
        this.isOptimalWindow = bl;
    }

    public double getCenter() {
        return this.center;
    }

    public int getCenterAsInt() {
        return (int)this.center;
    }

    public int getWidthAsInt() {
        return (int)this.width;
    }

    public void setInvalid() {
        this.width = -1.0;
    }

    public boolean isInvalid() {
        boolean bl;
        try {
            bl = this.width <= 0.0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        return bl;
    }

    public void setCenter(double d) {
        this.center = d;
    }

    public String toString() {
        try {
            if (this.explanation == null) {
                return "width/center : " + this.width + "/" + this.center + " isOffsetWindow:" + this.isOffsetWindow + " isOptimalWindow:" + this.isOptimalWindow + " isUserPreset:" + this.isUserPreset + " isWindowRange:" + this.isWindowRange;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        return "Name: " + this.explanation + "; width/center: " + this.width + "/" + this.center + " isOffsetWindow:" + this.isOffsetWindow + " isOptimalWindow:" + this.isOptimalWindow + " isUserPreset:" + this.isUserPreset + " isWindowRange:" + this.isWindowRange;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 31;
        int n12 = 1;
        long l = Double.doubleToLongBits(this.center);
        n12 = 31 * n12 + (int)(l ^ l >>> 32);
        try {
            n10 = 31 * n12;
            n9 = this.explanation == null ? 0 : this.explanation.hashCode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        n12 = n10 + n9;
        try {
            n8 = 31 * n12;
            n7 = this.isOffsetWindow ? 1231 : 1237;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        n12 = n8 + n7;
        try {
            n6 = 31 * n12;
            n5 = this.isOptimalWindow ? 1231 : 1237;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        n12 = n6 + n5;
        try {
            n4 = 31 * n12;
            n3 = this.isUserPreset ? 1231 : 1237;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        n12 = n4 + n3;
        try {
            n2 = 31 * n12;
            n = this.isWindowRange ? 1231 : 1237;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        n12 = n2 + n;
        l = Double.doubleToLongBits(this.width);
        n12 = 31 * n12 + (int)(l ^ l >>> 32);
        return n12;
    }

    public boolean equals(Object object) {
        DicomWindow dicomWindow;
        block35: {
            block34: {
                try {
                    if (this == object) {
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomWindow.a(illegalArgumentException);
                }
                try {
                    if (object == null) {
                        return false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomWindow.a(illegalArgumentException);
                }
                try {
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomWindow.a(illegalArgumentException);
                }
                dicomWindow = (DicomWindow)object;
                try {
                    if (Double.doubleToLongBits(this.center) != Double.doubleToLongBits(dicomWindow.center)) {
                        return false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomWindow.a(illegalArgumentException);
                }
                try {
                    try {
                        if (this.explanation != null) break block34;
                        if (dicomWindow.explanation == null) break block35;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DicomWindow.a(illegalArgumentException);
                    }
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomWindow.a(illegalArgumentException);
                }
            }
            try {
                if (!this.explanation.equals(dicomWindow.explanation)) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomWindow.a(illegalArgumentException);
            }
        }
        try {
            if (this.isOffsetWindow != dicomWindow.isOffsetWindow) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        try {
            if (this.isOptimalWindow != dicomWindow.isOptimalWindow) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        try {
            if (this.isUserPreset != dicomWindow.isUserPreset) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        try {
            if (this.isWindowRange != dicomWindow.isWindowRange) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        try {
            if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(dicomWindow.width)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        return true;
    }

    public Object clone() {
        return new DicomWindow(this.center, this.width, this.explanation);
    }

    public DicomWindow createCopy() {
        DicomWindow dicomWindow = new DicomWindow(this.center, this.width, this.explanation);
        dicomWindow.attributes = new HashSet(this.attributes);
        return dicomWindow;
    }

    public final String createString_(String string) {
        return string + "_" + (int)this.center + "_" + (int)this.width;
    }

    public static final DicomWindow createFromString_(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string != null && string.length() >= 3) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomWindow.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Invalid Data for String " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomWindow.a(illegalArgumentException);
            }
        }
        int n = string.indexOf(95) + 1;
        int n2 = string.indexOf(95, n);
        try {
            if (n2 == -1) {
                throw new IllegalArgumentException("Invalid Data for String " + string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomWindow.a(illegalArgumentException);
        }
        return new DicomWindow(Integer.parseInt(string.substring(n, n2)), Integer.parseInt(string.substring(n2 + 1, string.length())));
    }

    public void setAttribute(Object object) {
        this.attributes.add(object);
    }

    public boolean hasAttribute(Object object) {
        return this.attributes.contains(object);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

