/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.sr.breastimaging;

import com.visustt.dicomTk.sr.breastimaging.IReportAnnotation;
import com.visustt.dicomTk.sr.breastimaging.IReportFinding;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class ReportAnnotation
implements IReportAnnotation,
Serializable {
    private static final long serialVersionUID = -3850568868434L;
    private boolean dicomTextOffset = false;
    private long id;
    private long jivePresentationStateDataID;
    private String annotationLayer;
    private String annotationType;
    private int annotationFlags = 0;
    private double measuredValue = 0.0;
    private double[] annotationData;
    private String referencedSOPClassUID;
    private String referencedSOPInstanceUID;
    private String prefix;
    private IReportFinding finding;
    private IReportAnnotation parent;
    private String distanceLayer;
    private String orbitLayer;
    private String projectionLineLayer;
    private String annotationUnits;
    private String laterality;
    private double[] textOffset;
    private String viewPosition;

    public void setAnnotationFlags(int n) {
        this.annotationFlags = n;
    }

    public void setAnnotationLayer(String string) {
        this.annotationLayer = string;
    }

    public void setAnnotationType(String string) {
        this.annotationType = string;
    }

    public void setID(long l) {
        this.id = l;
    }

    public void setJivePresentationStateDataID(long l) {
        this.jivePresentationStateDataID = l;
    }

    public void setMeasuredValue(double d) {
        this.measuredValue = d;
    }

    public void setReferencedSOPClassUID(String string) {
        this.referencedSOPClassUID = string;
    }

    public void setReferencedSOPInstanceUID(String string) {
        this.referencedSOPInstanceUID = string;
    }

    @Override
    public String getViewPosition() {
        return this.viewPosition;
    }

    public void setViewPosition(String string) {
        this.viewPosition = string;
    }

    @Override
    public void setAnnotationFilled(boolean bl) {
        this.annotationFlags = bl ? ReportAnnotation.setBit(this.annotationFlags, 2) : ReportAnnotation.clearBit(this.annotationFlags, 2);
    }

    @Override
    public void setLocked(boolean bl) {
        this.annotationFlags = bl ? ReportAnnotation.setBit(this.annotationFlags, 3) : ReportAnnotation.clearBit(this.annotationFlags, 3);
    }

    @Override
    public void setMamillaDistance(boolean bl) {
        this.annotationFlags = bl ? ReportAnnotation.setBit(this.annotationFlags, 1) : ReportAnnotation.clearBit(this.annotationFlags, 1);
    }

    @Override
    public double[] getAnnotationData() {
        if (this.annotationData == null) {
            return new double[0];
        }
        double[] dArray = new double[this.annotationData.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.annotationData[i];
        }
        return dArray;
    }

    public void setTextOffset(Point2D.Double double_) {
        this.textOffset = double_ == null ? new double[]{0.0, 0.0} : new double[]{double_.x, double_.y};
    }

    @Override
    public boolean isDicomTextOffset() {
        return this.dicomTextOffset;
    }

    public void setDicomTextOffset(boolean bl) {
        this.dicomTextOffset = bl;
    }

    @Override
    public Point2D.Double getTextOffset() {
        if (this.textOffset != null && this.textOffset.length >= 2) {
            return new Point2D.Double(this.textOffset[0], this.textOffset[1]);
        }
        return new Point2D.Double();
    }

    @Override
    public String getLaterality() {
        return this.laterality;
    }

    public void setLaterality(String string) {
        this.laterality = string;
    }

    public void setAnnotationUnits(String string) {
        this.annotationUnits = string;
    }

    public void setAnnotationData(double[] dArray) {
        if (dArray == null) {
            this.annotationData = null;
        } else {
            this.annotationData = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.annotationData[i] = dArray[i];
            }
        }
    }

    public void setFinding(IReportFinding iReportFinding) {
        this.finding = iReportFinding;
    }

    @Override
    public IReportFinding getFinding() {
        return this.finding;
    }

    @Override
    public IReportAnnotation getParentAnnotation() {
        return this.parent;
    }

    public void setParentAnnotation(IReportAnnotation iReportAnnotation) {
        this.parent = iReportAnnotation;
    }

    @Override
    public int getAnnotationFlags() {
        return this.annotationFlags;
    }

    @Override
    public String getAnnotationLayer() {
        return this.annotationLayer;
    }

    @Override
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public void setDistanceLayer(String string) {
        this.distanceLayer = string;
    }

    @Override
    public void setOrbitLayer(String string) {
        this.orbitLayer = string;
    }

    @Override
    public void setProjectionLineLayer(String string) {
        this.projectionLineLayer = string;
    }

    @Override
    public String getDistanceLayer() {
        return this.distanceLayer;
    }

    @Override
    public String getOrbitLayer() {
        return this.orbitLayer;
    }

    @Override
    public String getProjectionLineLayer() {
        return this.projectionLineLayer;
    }

    @Override
    public String getAnnotationUnits() {
        return this.annotationUnits;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public long getJivePresentationStateDataID() {
        return this.jivePresentationStateDataID;
    }

    @Override
    public double getMeasuredValue() {
        return this.measuredValue;
    }

    @Override
    public String getReferencedSOPClassUID() {
        return this.referencedSOPClassUID;
    }

    @Override
    public String getReferencedSOPInstanceUID() {
        return this.referencedSOPInstanceUID;
    }

    @Override
    public String getTextPrefix() {
        return this.prefix;
    }

    public void setTextPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public boolean isMamillaDistance() {
        return ReportAnnotation.testBit(this.annotationFlags, 1);
    }

    @Override
    public boolean isAnnotationFilled() {
        return ReportAnnotation.testBit(this.annotationFlags, 2);
    }

    @Override
    public boolean isLocked() {
        return ReportAnnotation.testBit(this.annotationFlags, 3);
    }

    public String toString() {
        return "{Annotation: id=" + this.getID() + ", type=" + this.getAnnotationType() + ", layer=" + this.getAnnotationLayer() + "}";
    }

    private static boolean testBit(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    private static int setBit(int n, int n2) {
        return n | 1 << n2;
    }

    private static int clearBit(int n, int n2) {
        return n & ~(1 << n2);
    }
}

