/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.model.internalpstate.regionOfInterest;

import com.visustt.dicomTk.imaging.ab.ah;
import com.visustt.dicomTk.model.internalpstate.regionOfInterest.DoubleStats;
import com.visustt.dicomTk.model.internalpstate.regionOfInterest.ROIStats;
import com.visustt.dicomTk.model.internalpstate.regionOfInterest.SUVTransformation;
import com.visustt.dicomTk.model.internalpstate.regionOfInterest.shapes.GeometricShape;
import java.awt.Point;
import java.text.DecimalFormat;

public class ROICalculation {
    private GeometricShape shape;
    private double currentPixelSpacingX = 1.0;
    private double currentPixelSpacingY = 1.0;
    private double altCurrentPixelSpacingX = 1.0;
    private double altCurrentPixelSpacingY = 1.0;
    private boolean hasPixelSpacing;
    private boolean shouldAddCorrectedPixelSpacing;
    private boolean isMicrometerUnit;
    private int width;
    private int height;
    private int frameOffset;
    private short[] imageData;
    private byte[] imageDataBytes;
    private int[] imageDataInts;
    private boolean unsigned;
    private ah modLut;
    private SUVTransformation suvTransformation;
    private boolean isRGB;
    private boolean isSuv;
    private String suvCalculationType;
    private boolean isHounsfieldUnit;
    private boolean includeCoordsOutsideOfImage;
    private String dicomCorrectedCaption;

    public void setShape(GeometricShape geometricShape) {
        this.shape = geometricShape;
    }

    public GeometricShape getShape() {
        return this.shape;
    }

    public void setCurrentPixelSpacing(double d, double d2) {
        this.currentPixelSpacingX = d;
        this.currentPixelSpacingY = d2;
    }

    public void setAltCurrentPixelSpacing(double d, double d2) {
        this.altCurrentPixelSpacingX = d;
        this.altCurrentPixelSpacingY = d2;
    }

    public void setHasPixelSpacing(boolean bl) {
        this.hasPixelSpacing = bl;
    }

    public void setShouldAddCorrectedPixelSpacing(boolean bl) {
        this.shouldAddCorrectedPixelSpacing = bl;
    }

    public void setMicrometerUnit(boolean bl) {
        this.isMicrometerUnit = bl;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setFrameOffset(int n) {
        this.frameOffset = n;
    }

    public void setImageDataShorts(short[] sArray) {
        this.imageData = sArray;
    }

    public void setImageDataBytes(byte[] byArray) {
        this.imageDataBytes = byArray;
    }

    public void setImageDataInts(int[] nArray) {
        this.imageDataInts = nArray;
    }

    public void setUnsigned(boolean bl) {
        this.unsigned = bl;
    }

    public void setModLut(ah ah2) {
        this.modLut = ah2;
    }

    public void setSuvTransformation(SUVTransformation sUVTransformation) {
        this.suvTransformation = sUVTransformation;
    }

    public void setRGB(boolean bl) {
        this.isRGB = bl;
    }

    public void setSuv(boolean bl) {
        this.isSuv = bl;
    }

    public boolean isSuv() {
        return this.isSuv;
    }

    public void setSuvCalculationType(String string) {
        this.suvCalculationType = string;
    }

    public String getSuvCalculationType() {
        return this.suvCalculationType;
    }

    public void setHounsfieldUnit(boolean bl) {
        this.isHounsfieldUnit = bl;
    }

    public void setDicomCorrectedCaption(String string) {
        this.dicomCorrectedCaption = string;
    }

    public void setIncludeCoordsOutsideOfImage(boolean bl) {
        this.includeCoordsOutsideOfImage = bl;
    }

    public ROIStats calculate() {
        ROIStats rOIStats = new ROIStats();
        DoubleStats doubleStats = new DoubleStats();
        this.collectPixelStatsValues(doubleStats);
        rOIStats.setMin(doubleStats.getMin());
        rOIStats.setMax(doubleStats.getMax());
        rOIStats.setMedian(doubleStats.getMedian());
        rOIStats.setAvg(doubleStats.getAverage());
        rOIStats.setStdDev(doubleStats.getStandardDeviation());
        int n = this.isMicrometerUnit ? 1000 : 1;
        rOIStats.setArea(this.currentPixelSpacingX * (double)n * this.currentPixelSpacingY * (double)n * this.shape.getArea());
        rOIStats.setAltArea(this.altCurrentPixelSpacingX * (double)n * this.altCurrentPixelSpacingY * (double)n * this.shape.getArea());
        if (!this.shouldAddCorrectedPixelSpacing) {
            rOIStats.setAltArea(rOIStats.getArea());
        }
        rOIStats.setText(this.buildText(rOIStats));
        return rOIStats;
    }

    protected void collectPixelStatsValues(final DoubleStats doubleStats) {
        if (this.imageData != null || this.imageDataBytes != null || this.imageDataInts != null) {
            this.shape.foreachCoord(new GeometricShape.ac(){

                @Override
                public void aa(Point point) {
                    int n = point.x;
                    int n2 = point.y;
                    int n3 = 0;
                    if (n < 0 || n2 < 0 || n >= ROICalculation.this.width || n2 >= ROICalculation.this.height) {
                        if (!ROICalculation.this.includeCoordsOutsideOfImage) {
                            return;
                        }
                        n3 = 0;
                    } else if (ROICalculation.this.imageData != null) {
                        n3 = ROICalculation.this.imageData[ROICalculation.this.frameOffset + n + n2 * ROICalculation.this.width];
                    } else if (ROICalculation.this.imageDataBytes != null) {
                        n3 = ROICalculation.this.imageDataBytes[ROICalculation.this.frameOffset + n + n2 * ROICalculation.this.width];
                    } else if (ROICalculation.this.imageDataInts != null) {
                        n3 = ROICalculation.this.imageDataInts[ROICalculation.this.frameOffset + n + n2 * ROICalculation.this.width];
                    }
                    if (ROICalculation.this.unsigned) {
                        n3 = ROICalculation.this.imageData != null ? (n3 &= 0xFFFF) : (n3 &= 0xFF);
                    }
                    if (ROICalculation.this.modLut != null) {
                        n3 = ROICalculation.this.modLut.ab(n3);
                    }
                    if (ROICalculation.this.suvTransformation != null) {
                        doubleStats.add(ROICalculation.this.suvTransformation.transform(n3));
                    } else {
                        doubleStats.add(n3);
                    }
                }
            });
        }
    }

    private String buildText(ROIStats rOIStats) {
        StringBuilder stringBuilder = new StringBuilder(89);
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        DecimalFormat decimalFormat2 = this.isSuv ? new DecimalFormat("0.###") : new DecimalFormat("0.##");
        String string = "";
        if (this.isHounsfieldUnit) {
            string = " HU";
        } else if (this.isSuv) {
            if ("SUVBW".equals(this.suvCalculationType)) {
                string = " SUVbw";
            } else if ("SUVBSA".equals(this.suvCalculationType)) {
                string = " SUVbsa";
            } else if ("SUVLBM".equals(this.suvCalculationType)) {
                string = " SUVlbm";
            } else if ("SUVPHILIPS".equals(this.suvCalculationType)) {
                string = " SUV Philips";
            }
        }
        if (!(Double.isInfinite(rOIStats.getMin()) || Double.isInfinite(rOIStats.getMax()) || this.isRGB)) {
            stringBuilder.append("Avg=").append(decimalFormat.format(rOIStats.getAvg()));
            stringBuilder.append(string);
            stringBuilder.append("  Min=").append(decimalFormat2.format(rOIStats.getMin()));
            stringBuilder.append(string);
            stringBuilder.append("  Max=").append(decimalFormat2.format(rOIStats.getMax()));
            stringBuilder.append(string);
            stringBuilder.append("\n");
            stringBuilder.append("Std.Dev=").append(decimalFormat.format(rOIStats.getStdDev()));
            stringBuilder.append(string);
            stringBuilder.append("  Median=").append(decimalFormat2.format(rOIStats.getMedian()));
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        stringBuilder.append(decimalFormat.format(rOIStats.getAltArea()));
        if (!this.hasPixelSpacing) {
            stringBuilder.append(" pixel  /  ");
        } else if (this.isMicrometerUnit) {
            stringBuilder.append(" \u00b5m\u00b2  /  ");
        } else {
            stringBuilder.append(" mm\u00b2  /  ");
        }
        stringBuilder.append(this.shape.getAreaString()).append(" pixel\n");
        if (rOIStats.getArea() != rOIStats.getAltArea()) {
            stringBuilder.append("(" + this.dicomCorrectedCaption + ": ");
            stringBuilder.append(decimalFormat.format(rOIStats.getArea()));
            if (this.hasPixelSpacing) {
                if (this.isMicrometerUnit) {
                    stringBuilder.append(" \u00b5m\u00b2)");
                } else {
                    stringBuilder.append(" mm\u00b2)");
                }
            }
        }
        return stringBuilder.toString();
    }
}

