/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.imaging;

import com.visustt.dicomTk.DicomObject;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.DicomElementFormaterFactory;
import com.visustt.dicomTk.data.aw;
import com.visustt.dicomTk.imaging.TagDrawingCondition;
import com.visustt.dicomTk.imaging.ae;
import com.visustt.dicomTk.model.ag;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.ab;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class TagDrawingInformation
implements Serializable {
    static final long serialVersionUID = 8285481913206532720L;
    private static volatile Logger logger = LoggerFactory.getInstance("jx.vb..gui.tagdrawinfo");
    private TagDrawingCondition[] condition;
    private DicomTag[] dicomTags;
    private int[] elementIndexes;
    private String separator;
    private String suffix;
    private String description;
    private int location;
    private Double multiplicator;
    private Integer fractionalDigits;

    public TagDrawingInformation(TagDrawingCondition[] tagDrawingConditionArray, String string, DicomTag[] dicomTagArray, int[] nArray, String string2, String string3, int n, Double d, Integer n2) {
        this.condition = tagDrawingConditionArray;
        this.dicomTags = dicomTagArray;
        this.elementIndexes = nArray;
        this.separator = string2;
        this.suffix = string3;
        this.description = string;
        this.location = n;
        this.multiplicator = d;
        this.fractionalDigits = n2;
    }

    public boolean matches(DicomObject dicomObject) {
        int n = 0;
        while (true) {
            block5: {
                try {
                    try {
                        if (n >= this.condition.length) break;
                        if (this.tdcMatches(this.condition[n], dicomObject)) break block5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw TagDrawingInformation.a(numberFormatException);
                    }
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    throw TagDrawingInformation.a(numberFormatException);
                }
            }
            ++n;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private boolean tdcMatches(TagDrawingCondition tagDrawingCondition, DicomObject dicomObject) {
        block16: {
            try {
                if (tagDrawingCondition.conditionTrue()) {
                    return true;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw TagDrawingInformation.a(invalidDataException);
            }
            if (tagDrawingCondition.getTagNumber() != DicomTagNames.TAG_modality.getTagNumber()) break block16;
            try {
                block17: {
                    if (!tagDrawingCondition.getValue().equals(dicomObject.getSeriesModule().getModality())) break block16;
                    break block17;
                    catch (InvalidDataException invalidDataException) {
                        throw TagDrawingInformation.a(invalidDataException);
                    }
                }
                return true;
            }
            catch (InvalidDataException invalidDataException) {
                throw TagDrawingInformation.a(invalidDataException);
            }
        }
        DicomElement dicomElement = dicomObject.getDicomElement(tagDrawingCondition.getTagNumber());
        try {
            if (dicomElement == null) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw TagDrawingInformation.a(invalidDataException);
        }
        try {
            if (dicomElement.getValueMultiplication() == 0) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw TagDrawingInformation.a(invalidDataException);
        }
        try {
            String string = dicomElement.getValueAsString(0);
            if (StringTool.matchWildCardIgnoreCase(string, tagDrawingCondition.getValue())) {
                return true;
            }
        }
        catch (InvalidDataException invalidDataException) {
            logger.error((Object)("Error in TagDrawingInformation.tdcMatches() " + invalidDataException), invalidDataException);
        }
        return false;
    }

    public ae createConcreteTagDrawingInfo(ag ag2) {
        Object object;
        block9: {
            object = null;
            for (int i = 0; i < this.dicomTags.length; ++i) {
                String string;
                block8: {
                    string = this.getDicomElementRepresentation(ag2, this.dicomTags[i], this.elementIndexes[i]);
                    try {
                        if (string == null) continue;
                        if (object != null) break block8;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw TagDrawingInformation.a(numberFormatException);
                    }
                    object = string;
                    continue;
                }
                object = (String)object + this.separator + string;
            }
            try {
                try {
                    if (object != null && !((String)object).trim().isEmpty()) break block9;
                }
                catch (NumberFormatException numberFormatException) {
                    throw TagDrawingInformation.a(numberFormatException);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                throw TagDrawingInformation.a(numberFormatException);
            }
        }
        if (this.suffix != null) {
            object = (String)object + this.suffix;
        }
        List<DicomTag> list = Arrays.asList(this.dicomTags);
        return new ae(this.description, (String)object, this.location, list);
    }

    /*
     * Loose catch block
     */
    protected String getDicomElementRepresentation(ag ag2, DicomTag dicomTag, int n) {
        String string;
        block18: {
            String string2;
            block19: {
                DicomElement dicomElement;
                block15: {
                    DicomObject dicomObject = ag2.an;
                    string = null;
                    dicomElement = dicomObject.getDicomElement(dicomTag);
                    double d = Optional.ofNullable(this.multiplicator).map(Double::doubleValue).orElse(1.0);
                    int n2 = Optional.ofNullable(this.fractionalDigits).map(Integer::intValue).orElse(-1);
                    try {
                        block17: {
                            block16: {
                                block21: {
                                    block20: {
                                        if (ag2.ak.contains(dicomTag)) break block15;
                                        if (dicomElement == null) break block15;
                                        break block20;
                                        catch (NumberFormatException numberFormatException) {
                                            throw TagDrawingInformation.a(numberFormatException);
                                        }
                                    }
                                    if (dicomElement.getValueMultiplication() <= n) break block15;
                                    break block21;
                                    catch (NumberFormatException numberFormatException) {
                                        throw TagDrawingInformation.a(numberFormatException);
                                    }
                                }
                                try {
                                    block22: {
                                        if (dicomTag.equals(DicomTagNames.TAG_patientsID)) break block16;
                                        break block22;
                                        catch (NumberFormatException numberFormatException) {
                                            throw TagDrawingInformation.a(numberFormatException);
                                        }
                                    }
                                    if (!DicomTagNames.TAG_accessionNumber.equals(dicomTag)) break block17;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw TagDrawingInformation.a(numberFormatException);
                                }
                            }
                            string = dicomElement.getValueAsString(n);
                            break block15;
                        }
                        string2 = dicomElement.getValueAsScaledDouble(n, d, n2);
                        if (string2 == null) {
                            string2 = DicomElementFormaterFactory.getDicomElementFormater().formatError(dicomElement, n);
                        }
                        string = string2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (dicomElement != null) {
                            string = dicomElement.toString();
                        }
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        // empty catch block
                    }
                }
                string2 = this.getStringValueForUNValueRepElement(dicomElement);
                try {
                    if (string2 == null) break block18;
                    if (!string2.trim().isEmpty()) break block19;
                }
                catch (NumberFormatException numberFormatException) {
                    throw TagDrawingInformation.a(numberFormatException);
                }
                string = null;
                break block18;
            }
            string = string2;
        }
        return string;
    }

    protected String getStringValueForUNValueRepElement(DicomElement dicomElement) {
        String string;
        block6: {
            string = null;
            if (dicomElement instanceof aw) {
                block5: {
                    aw aw2 = (aw)dicomElement;
                    byte[] byArray = aw2.aa();
                    try {
                        if (byArray == null || byArray.length <= 0) break block5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw TagDrawingInformation.a(numberFormatException);
                    }
                    boolean bl = StringTool.isPrintable(byArray);
                    if (bl) {
                        string = new String(byArray).trim();
                    } else {
                        StringBuffer stringBuffer = ab.aa(byArray, 0, byArray.length);
                        string = stringBuffer.toString();
                    }
                    break block6;
                }
                string = "";
            }
        }
        return string;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

