/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.dict;

import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.dict.ElementInformation;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.FileAccess;
import com.visustt.tools.lang.StringTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;

public class DicomDictionary {
    private static final int FIELD_TAG = 0;
    private static final int FIELD_VR = 1;
    private static final int FIELD_VM = 2;
    private static final int FIELD_NAME = 3;
    private static final int FIELD_KEY = 4;
    private static final int FIELD_EXT = 5;
    private static final String STD_DICT = "com/visustt/resources/dicomTk/dictionary";
    private static Logger logger = LoggerFactory.getInstance("jx.dicomtk.dictionary");
    private static DicomDictionary theInstance = null;
    private Map<DicomTag, ElementInformation> dictElements = new TreeMap<DicomTag, ElementInformation>();
    private final Map<DicomTag, String> keywords = new TreeMap<DicomTag, String>();
    private Map<String, DicomTag> reverseKeywords = new TreeMap<String, DicomTag>(String.CASE_INSENSITIVE_ORDER);

    private DicomDictionary() {
        try {
            this.load(STD_DICT);
            if (logger.debugIsEnabled()) {
                logger.debug("Dictionary contains #" + this.dictElements.size() + " elements!");
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Cannot load dictionary (perhaps not in JAR):" + exception), exception);
            this.dictElements = null;
        }
    }

    public static DicomDictionary instance() {
        try {
            if (theInstance == null) {
                theInstance = new DicomDictionary();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw DicomDictionary.a(stringIndexOutOfBoundsException);
        }
        return theInstance;
    }

    public final ElementInformation searchElement(DicomTag dicomTag) {
        try {
            if (dicomTag != null) {
                return this.dictElements.get(dicomTag);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw DicomDictionary.a(stringIndexOutOfBoundsException);
        }
        return null;
    }

    public Map<DicomTag, ElementInformation> getVector() {
        return this.dictElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void load(String var1_1) throws IOException, NumberFormatException {
        block26: {
            var2_2 = FileAccess.getStream(var1_1);
            try {
                var3_3 = new BufferedReader(new InputStreamReader(var2_2));
                var4_4 = null;
                var5_5 = 0;
                while (true) {
                    block30: {
                        block29: {
                            block32: {
                                block28: {
                                    block27: {
                                        var4_4 = var3_3.readLine();
                                        if (var4_4 == null) break block26;
                                        try {
                                            block31: {
                                                if (!DicomDictionary.logger.debugIsEnabled()) break block27;
                                                break block31;
                                                catch (StringIndexOutOfBoundsException v0) {
                                                    throw DicomDictionary.a(v0);
                                                }
                                            }
                                            DicomDictionary.logger.debug("read line #" + var5_5);
                                        }
                                        catch (StringIndexOutOfBoundsException v1) {
                                            throw DicomDictionary.a(v1);
                                        }
                                    }
                                    var4_4 = var4_4.trim();
                                    try {
                                        if (var4_4.length() <= 0 || var4_4.charAt(0) != '(') break block28;
                                    }
                                    catch (StringIndexOutOfBoundsException v2) {
                                        throw DicomDictionary.a(v2);
                                    }
                                    try {
                                        var6_6 = this.parseLine(var4_4);
                                        try {
                                            if (DicomDictionary.logger.debugIsEnabled()) {
                                                DicomDictionary.logger.debug("parsed DICOM element: " + var6_6);
                                            }
                                        }
                                        catch (StringIndexOutOfBoundsException v3) {
                                            throw DicomDictionary.a(v3);
                                        }
                                        try {
                                            if (var6_6 == null) ** GOTO lbl71
                                            this.dictElements.put(var6_6.getDicomTag(), var6_6);
                                        }
                                        catch (StringIndexOutOfBoundsException v4) {
                                            throw DicomDictionary.a(v4);
                                        }
                                    }
                                    catch (StringIndexOutOfBoundsException var6_7) {
                                        throw new NumberFormatException(var4_4);
                                    }
                                }
                                if (var4_4.startsWith("#")) ** GOTO lbl52
                                if (!var4_4.startsWith("//")) break block29;
                                break block32;
                                catch (StringIndexOutOfBoundsException v5) {
                                    throw DicomDictionary.a(v5);
                                }
                            }
                            try {
                                block33: {
                                    if (!DicomDictionary.logger.debugIsEnabled()) break block30;
                                    break block33;
                                    catch (StringIndexOutOfBoundsException v6) {
                                        throw DicomDictionary.a(v6);
                                    }
                                }
                                DicomDictionary.logger.debug("skip comment line:" + var5_5);
                                break block30;
                            }
                            catch (StringIndexOutOfBoundsException v7) {
                                throw DicomDictionary.a(v7);
                            }
                        }
                        try {
                            if (var4_4.length() > 0) {
                                DicomDictionary.logger.warn("Invalid line format in dictionary (line #" + var5_5 + ")");
                                throw new NumberFormatException(var4_4);
                            }
                        }
                        catch (StringIndexOutOfBoundsException v8) {
                            throw DicomDictionary.a(v8);
                        }
                    }
                    ++var5_5;
                }
            }
            finally {
                var2_2.close();
            }
        }
    }

    private ElementInformation parseLine(String string) {
        String string2;
        String string3;
        String string4;
        DicomTag dicomTag;
        StringBuilder[] stringBuilderArray;
        block42: {
            block41: {
                block40: {
                    block39: {
                        block38: {
                            try {
                                if (string == null) {
                                    return null;
                                }
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                throw DicomDictionary.a(stringIndexOutOfBoundsException);
                            }
                            stringBuilderArray = new StringBuilder[6];
                            int n = 0;
                            int n2 = 0;
                            while (true) {
                                block37: {
                                    block36: {
                                        try {
                                            try {
                                                if (n2 >= string.length() || n > stringBuilderArray.length) {
                                                    break;
                                                }
                                            }
                                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                                throw DicomDictionary.a(stringIndexOutOfBoundsException);
                                            }
                                        }
                                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                            throw DicomDictionary.a(stringIndexOutOfBoundsException);
                                        }
                                        try {
                                            if (stringBuilderArray[n] == null) {
                                                stringBuilderArray[n] = new StringBuilder();
                                            }
                                        }
                                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                            throw DicomDictionary.a(stringIndexOutOfBoundsException);
                                        }
                                        char c = string.charAt(n2);
                                        try {
                                            if (c == ';') break block36;
                                            stringBuilderArray[n].append(c);
                                            break block37;
                                        }
                                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                            throw DicomDictionary.a(stringIndexOutOfBoundsException);
                                        }
                                    }
                                    ++n;
                                }
                                ++n2;
                            }
                            try {
                                try {
                                    if (stringBuilderArray[0] != null && stringBuilderArray[0].length() == 11) break block38;
                                }
                                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                    throw DicomDictionary.a(stringIndexOutOfBoundsException);
                                }
                                throw new IllegalArgumentException("Invalid DICOM Tag on line '" + string + "'");
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                throw DicomDictionary.a(stringIndexOutOfBoundsException);
                            }
                        }
                        try {
                            try {
                                if (stringBuilderArray[1] != null && stringBuilderArray[1].length() >= 2) break block39;
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                throw DicomDictionary.a(stringIndexOutOfBoundsException);
                            }
                            throw new IllegalArgumentException("Invalid element VR on line '" + string + "'");
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            throw DicomDictionary.a(stringIndexOutOfBoundsException);
                        }
                    }
                    try {
                        try {
                            if (stringBuilderArray[2] != null && stringBuilderArray[2].length() >= 1) break block40;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            throw DicomDictionary.a(stringIndexOutOfBoundsException);
                        }
                        throw new IllegalArgumentException("Invalid element VM on line '" + string + "'");
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw DicomDictionary.a(stringIndexOutOfBoundsException);
                    }
                }
                try {
                    try {
                        if (stringBuilderArray[3] != null && stringBuilderArray[3].length() >= 1) break block41;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw DicomDictionary.a(stringIndexOutOfBoundsException);
                    }
                    throw new IllegalArgumentException("Invalid element name on line '" + string + "'");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw DicomDictionary.a(stringIndexOutOfBoundsException);
                }
            }
            dicomTag = new DicomTag(stringBuilderArray[0].toString());
            string4 = stringBuilderArray[1].toString();
            string3 = stringBuilderArray[2].toString();
            string2 = "";
            try {
                if (stringBuilderArray[5] == null || stringBuilderArray[5].length() <= 0) break block42;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw DicomDictionary.a(stringIndexOutOfBoundsException);
            }
            string2 = stringBuilderArray[5].toString();
        }
        String string5 = stringBuilderArray[3].toString().replaceAll("\"", "");
        String string6 = null;
        string6 = stringBuilderArray[4] != null ? stringBuilderArray[4].toString() : StringTool.toCamelCase(StringTool.splitCamelCase(string5), false, true);
        try {
            if (string6 != null) {
                this.keywords.put(dicomTag, string6);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw DicomDictionary.a(stringIndexOutOfBoundsException);
        }
        return new ElementInformation(dicomTag, string4, string3, string5, string2, dicomTag.isPrivateElement());
    }

    public void insert(DicomTag dicomTag, String string, String string2, String string3, boolean bl) {
        ElementInformation elementInformation = new ElementInformation(dicomTag, string, string2, string3, null, bl);
        this.dictElements.put(dicomTag, elementInformation);
    }

    public String getKeyword(DicomTag dicomTag) {
        return this.keywords.get(dicomTag);
    }

    public static String keyToDicomTagName(String string) {
        String string2 = null;
        if (string.matches("\\(\\b[0-9a-fA-F]{4}\\b,\\b[0-9a-fA-F]{4}\\b\\)")) {
            try {
                DicomTag dicomTag = new DicomTag(string);
                ElementInformation elementInformation = DicomDictionary.instance().searchElement(dicomTag);
                if (elementInformation != null) {
                    string2 = elementInformation.getElementName();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string2;
    }

    public DicomTag searchTagByFieldName(String string) {
        try {
            if (this.reverseKeywords.isEmpty()) {
                this.initializeReverseKeywords();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw DicomDictionary.a(stringIndexOutOfBoundsException);
        }
        return this.reverseKeywords.get(string);
    }

    private void initializeReverseKeywords() {
        for (Map.Entry<DicomTag, String> entry : this.keywords.entrySet()) {
            ElementInformation elementInformation = this.dictElements.get(entry.getKey());
            try {
                try {
                    if (this.reverseKeywords.containsKey(entry.getValue()) || elementInformation.isRetired()) continue;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw DicomDictionary.a(stringIndexOutOfBoundsException);
                }
                this.reverseKeywords.put(entry.getValue(), entry.getKey());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw DicomDictionary.a(stringIndexOutOfBoundsException);
            }
        }
    }

    private static StringIndexOutOfBoundsException a(StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
        return stringIndexOutOfBoundsException;
    }
}

