/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.data;

import com.visustt.dicomTk.data.aat;
import com.visustt.dicomTk.data.ag;
import com.visustt.tools.lang.StringTool;
import java.util.HashSet;

public class TransferSyntaxValues
extends ag
implements aat {
    private static final HashSet<String> COMPRESSED_TRANSFER_SYNTAX = new HashSet();
    static TransferSyntaxValues theInstance;

    private TransferSyntaxValues() {
        this.ac = "UID";
        this.ab = "Name";
        this.aa.put("1.2.840.10008.1.2.4.50", "JPEG Baseline (Process 1): Lossy JPEG 8 Bit ");
        this.aa.put("1.2.840.10008.1.2.4.51", "JPEG Extendend (Process 2 & 4): Lossy JPEG 12 Bit");
        this.aa.put("1.2.840.10008.1.2.4.53", "JPEG Spectral Selection, Non-Hiercharchical (Process 6 & 8)");
        this.aa.put("1.2.840.10008.1.2.4.55", "JPEG Full Progression, Non-Hiercharchical (Process 10 & 12)");
        this.aa.put("1.2.840.10008.1.2.4.57", "JPEG Lossless, Non-Hiercharchical (Process 14)");
        this.aa.put("1.2.840.10008.1.2.4.70", "JPEG Lossless, Non-Hiercharchical First Order Prediction (Process 14 [Selection Value 1])");
        this.aa.put("1.2.840.10008.1.2.4.90", "JPEG 2000 Image Compression (Lossless Only)");
        this.aa.put("1.2.840.10008.1.2.4.91", "JPEG 2000 Image Compression");
        this.aa.put("1.2.840.10008.1.2.4.80", "JPEG-LS Lossless Image Compression");
        this.aa.put("1.2.840.10008.1.2.4.81", "JPEG-LS Lossy (Near-Lossless) Image Compression");
        this.aa.put("1.2.840.10008.1.2.4.100", "MPEG2 Main Profile @ Main Level");
        this.aa.put("1.2.840.10008.1.2.4.101", "MPEG2 Main Profile @ High Level");
        this.aa.put("1.2.840.10008.1.2.4.102", "MPEG-4 AVC/H.264 High Profile / Level 4.1");
        this.aa.put("1.2.840.10008.1.2.4.103", "MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1");
        this.aa.put("1.2.840.10008.1.2.4.96", "No Pixel Data");
        this.aa.put("1.2.276.0.50.1.2", "VISUS Implicit VR Little Endian");
        this.aa.put("1.2.276.0.50.1.2.1", "VISUS Explicit VR Little Endian");
        this.aa.put("1.2.276.0.50.1.2.2", "VISUS Explicit VR Big Endian");
        this.aa.put("1.2.276.0.501.2.4.51", "VISUS JPEG Extended Sequential");
        this.aa.put("1.2.276.0.501.2.4.55", "VISUS JPEG Full Progression");
        this.aa.put("1.2.276.0.501.2.4.57", "VISUS JPEG Lossless");
        this.aa.put("1.2.276.0.501.2.4.80", "VISUS JPEG LS Lossless");
        this.aa.put("1.2.276.0.501.2.4.81", "VISUS JPEG LS Lossy");
        this.aa.put("1.2.276.0.501.2.4.53", "VISUS JPEG Spectral Selection");
        this.aa.put("1.2.276.0.50.1.2.4.91", "VISUS JPEG 2000");
        this.aa.put("1.2.276.0.50.1.2.4.90", "JPEG 2000 Image Compression (Lossless Only)");
        this.aa.put("1.2.276.0.50.1.2.4.50", "VISUS JPEG Baseline (Process 1): Lossy JPEG 8 Bit");
        this.aa.put("1.2.276.0.50.1.2.4.70", "VISUS JPEG Standard Lossless");
        this.aa.put("1.2.276.0.50.99.99", "VISUS Enclosed");
        this.aa.put("1.2.276.0.50.1.2.5", "VISUS RLE Lossless");
    }

    public static TransferSyntaxValues instance() {
        if (theInstance == null) {
            theInstance = new TransferSyntaxValues();
        }
        return theInstance;
    }

    public static final boolean isVisusRoot(String string) {
        return string != null && string.length() >= "1.2.276.0.50".length() && string.startsWith("1.2.276.0.50");
    }

    public static final boolean isDicomRoot(String string) {
        return string != null && string.length() > "1.2.840.10008".length() && string.startsWith("1.2.840.10008");
    }

    public static final String createDicomRoot(String string) {
        if (TransferSyntaxValues.isVisusRoot(string)) {
            return StringTool.replaceString(string, "1.2.276.0.50", "1.2.840.10008");
        }
        return string;
    }

    public static final String createVisusRoot(String string) {
        if (TransferSyntaxValues.isDicomRoot(string)) {
            return StringTool.replaceString(string, "1.2.840.10008", "1.2.276.0.50");
        }
        return string;
    }

    public static final boolean isDefaultTransferSyntax(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("1.2.840.10008.1.2.1") || string.equals("1.2.840.10008.1.2") || string.equals("1.2.840.10008.1.2.2");
    }

    public static final boolean isMPEGTransferSyntax(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("1.2.840.10008.1.2.4.100") || string.equals("1.2.840.10008.1.2.4.101") || string.equals("1.2.840.10008.1.2.4.102") || string.equals("1.2.840.10008.1.2.4.103");
    }

    public static final boolean isLosslessTransferSyntax(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("1.2.840.10008.1.2.1") || string.equals("1.2.840.10008.1.2") || string.equals("1.2.840.10008.1.2.2") || string.equals("1.2.840.10008.1.2.5") || string.equals("1.2.840.10008.1.2.4.70") || string.equals("1.2.840.10008.1.2.4.57") || string.equals("1.2.840.10008.1.2.4.90") || string.equals("1.2.840.10008.1.2.4.80") || string.equals("1.2.276.0.50.1.2") || string.equals("1.2.276.0.50.1.2.1") || string.equals("1.2.276.0.50.1.2.4.90") || string.equals("1.2.276.0.501.2.4.57") || string.equals("1.2.276.0.501.2.4.80") || string.equals("1.2.276.0.50.1.2.4.70") || string.equals("1.2.276.0.50.1.2.2") || string.equals("1.2.276.0.50.1.2.5");
    }

    public static final boolean isLossyTransferSyntax(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("1.2.840.10008.1.2.4.50") || string.equals("1.2.840.10008.1.2.4.51") || string.equals("1.2.840.10008.1.2.4.53") || string.equals("1.2.840.10008.1.2.4.55") || string.equals("1.2.840.10008.1.2.4.81") || string.equals("1.2.840.10008.1.2.4.91");
    }

    public static boolean isCompressedTransferSyntax(String string) {
        return COMPRESSED_TRANSFER_SYNTAX.contains(string);
    }

    static {
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.50");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.51");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.57");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.70");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.90");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.91");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.100");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.101");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.102");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.4.103");
        COMPRESSED_TRANSFER_SYNTAX.add("1.2.840.10008.1.2.5");
        theInstance = null;
    }
}

