/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.data;

import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.PersonName;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.aaa;
import com.visustt.dicomTk.data.aae;
import com.visustt.dicomTk.data.aao;
import com.visustt.dicomTk.data.ay;
import com.visustt.dicomTk.data.az;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.text.al;
import com.visustt.tools.text.am;
import java.util.Date;

public class DicomElementFormater {
    private static final Logger logger = LoggerFactory.getInstance("jx.dicomtk.formater");
    private String datePattern = "dd.MM.yyyy";
    private String timePattern = "HH:mm:ss";
    private String dateTimePattern = "dd.MM.yyyy HH:mm:ss";
    private String personNamePattern = "12345";

    public String getPersonNamePattern() {
        return this.personNamePattern;
    }

    public void setPersonNamePattern(String string) {
        this.personNamePattern = string;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String string) {
        this.datePattern = string;
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(String string) {
        this.timePattern = string;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public void setDateTimePattern(String string) {
        this.dateTimePattern = string;
    }

    public String format(PersonName personName) {
        try {
            if (personName == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElementFormater.a(numberFormatException);
        }
        return personName.format(this.personNamePattern);
    }

    public String formatPersonName(String string) {
        try {
            if (string == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElementFormater.a(numberFormatException);
        }
        return this.format(new PersonName(this.personNamePattern));
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String format(DicomElement dicomElement, int n) throws InvalidDataException, NoValidValueIndexException {
        String string;
        String string2;
        block18: {
            block17: {
                block15: {
                    al al2;
                    block19: {
                        block16: {
                            if (dicomElement instanceof aae) {
                                String string3 = null;
                                if (n <= dicomElement.getValueMultiplication()) {
                                    string3 = dicomElement.getValueAsString(n);
                                }
                                if (string3 == null) return "";
                                PersonName personName = new PersonName(string3);
                                return this.format(personName);
                            }
                            try {
                                if (!(dicomElement instanceof ay)) break block15;
                                if (!(dicomElement instanceof az)) break block16;
                            }
                            catch (Exception exception) {
                                throw DicomElementFormater.a(exception);
                            }
                            al2 = am.aa(this.datePattern);
                            break block19;
                        }
                        al2 = dicomElement instanceof aaa ? am.aa(this.timePattern) : am.aa(this.dateTimePattern);
                    }
                    Date date = null;
                    if (n <= dicomElement.getValueMultiplication()) {
                        date = ((ay)dicomElement).ab(n);
                    }
                    try {
                        if (date == null) return "";
                        return al2.aa(date);
                    }
                    catch (Exception exception) {
                        throw DicomElementFormater.a(exception);
                    }
                }
                if (!(dicomElement instanceof aao)) return dicomElement.getValueAsString(n);
                string2 = dicomElement.getValueAsString(n);
                if (string2 == null) return "";
                try {
                    if (!string2.equals("")) break block17;
                    return "";
                    catch (Exception exception) {
                        throw DicomElementFormater.a(exception);
                    }
                }
                catch (Exception exception) {
                    throw DicomElementFormater.a(exception);
                }
            }
            string = string2.trim();
            if (!string.startsWith("+")) break block18;
            string = string.substring(1);
        }
        try {
            return "" + Integer.parseInt(string);
        }
        catch (Exception exception) {
            try {
                if (!logger.infoIsEnabled()) return "";
                logger.info("failed to parse integer '" + string2 + "':" + exception);
                return "";
            }
            catch (Exception exception2) {
                throw DicomElementFormater.a(exception2);
            }
        }
    }

    /*
     * Loose catch block
     */
    public String format(DicomElement dicomElement) throws InvalidDataException {
        try {
            if (dicomElement.getValueMultiplication() == 0) {
                return null;
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElementFormater.a(noValidValueIndexException);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            block13: {
                if (n >= dicomElement.getValueMultiplication()) break;
                try {
                    block14: {
                        if (n <= 0) break block13;
                        break block14;
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw DicomElementFormater.a(noValidValueIndexException);
                        }
                    }
                    stringBuffer.append(",");
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw DicomElementFormater.a(noValidValueIndexException);
                }
            }
            try {
                stringBuffer.append(this.format(dicomElement, n));
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                try {
                    if (logger.infoIsEnabled()) {
                        logger.info("failed to format element '" + dicomElement + "':" + noValidValueIndexException);
                    }
                }
                catch (NoValidValueIndexException noValidValueIndexException2) {
                    throw DicomElementFormater.a(noValidValueIndexException2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     */
    public String formatError(DicomElement dicomElement) {
        try {
            if (dicomElement.getValueMultiplication() == 0) {
                return null;
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElementFormater.a(noValidValueIndexException);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            block13: {
                if (n >= dicomElement.getValueMultiplication()) break;
                try {
                    block14: {
                        if (n <= 0) break block13;
                        break block14;
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw DicomElementFormater.a(noValidValueIndexException);
                        }
                    }
                    stringBuffer.append(",");
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw DicomElementFormater.a(noValidValueIndexException);
                }
            }
            try {
                stringBuffer.append(this.formatError(dicomElement, n));
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                try {
                    if (logger.infoIsEnabled()) {
                        logger.info("Failed to format element '" + dicomElement + "':" + noValidValueIndexException);
                    }
                }
                catch (NoValidValueIndexException noValidValueIndexException2) {
                    throw DicomElementFormater.a(noValidValueIndexException2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String formatError(DicomElement dicomElement, int n) throws NoValidValueIndexException {
        try {
            return this.format(dicomElement, n);
        }
        catch (InvalidDataException invalidDataException) {
            Object object;
            block5: {
                block6: {
                    object = dicomElement.getValueAsString(n);
                    try {
                        if (!(dicomElement instanceof aao)) break block5;
                        if (!((String)object).startsWith("+")) break block6;
                    }
                    catch (InvalidDataException invalidDataException2) {
                        throw DicomElementFormater.a(invalidDataException2);
                    }
                    object = ((String)object).substring(1);
                }
                object = "" + Integer.parseInt((String)object);
            }
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            String string = dicomElement.getValueAsString(n);
            return string;
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

