/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.data;

import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.InvalidValueIndexException;
import com.visustt.dicomTk.NoValidDicomObjectException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.PersonName;
import com.visustt.dicomTk.UnsupportedDicomObjectException;
import com.visustt.dicomTk.data.aaa;
import com.visustt.dicomTk.data.aac;
import com.visustt.dicomTk.data.aad;
import com.visustt.dicomTk.data.aae;
import com.visustt.dicomTk.data.aaf;
import com.visustt.dicomTk.data.aag;
import com.visustt.dicomTk.data.aan;
import com.visustt.dicomTk.data.aao;
import com.visustt.dicomTk.data.ai;
import com.visustt.dicomTk.data.aj;
import com.visustt.dicomTk.data.ak;
import com.visustt.dicomTk.data.al;
import com.visustt.dicomTk.data.am;
import com.visustt.dicomTk.data.an;
import com.visustt.dicomTk.data.ao;
import com.visustt.dicomTk.data.ap;
import com.visustt.dicomTk.data.ar;
import com.visustt.dicomTk.data.as;
import com.visustt.dicomTk.data.at;
import com.visustt.dicomTk.data.au;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.aw;
import com.visustt.dicomTk.data.ax;
import com.visustt.dicomTk.data.ay;
import com.visustt.dicomTk.data.az;
import com.visustt.dicomTk.dict.DicomDictionary;
import com.visustt.dicomTk.dict.ElementInformation;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.ag;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Vector;

public abstract class DicomElement
implements Comparable,
Cloneable {
    private static Logger logger = LoggerFactory.getInstance("jx.dicomTk");
    protected static final byte[] vmSeparator = new byte[]{92};
    protected static final char vmSeparatorChar = '\\';
    protected static final String vmSeparatorString = "\\";
    protected boolean specialVR = false;
    protected boolean checkEnabled = true;
    protected DicomTag dicomTag;
    protected String elementName;
    protected int valueMultiplication;
    protected int lengthOfValues;
    protected DicomElementList dicomElements = null;
    protected boolean _isValid = true;
    protected int fixedLengthSize = -1;

    public DicomElement(DicomTag dicomTag) {
        this.setElementName(dicomTag);
        this.valueMultiplication = 0;
        this.lengthOfValues = 0;
    }

    public void setElementName(DicomTag dicomTag) {
        block5: {
            block4: {
                this.dicomTag = dicomTag;
                DicomDictionary dicomDictionary = DicomDictionary.instance();
                ElementInformation elementInformation = dicomDictionary.searchElement(this.dicomTag);
                try {
                    if (elementInformation == null) break block4;
                    this.elementName = elementInformation.getElementName();
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomElement.b(numberFormatException);
                }
            }
            try {
                this.elementName = (this.dicomTag.getGroupNumber() & 1) == 1 ? "Private Tag" : "Unknown Tag";
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
        }
    }

    public abstract void readElement(com.visustt.dicomTk.util.ai var1, com.visustt.dicomTk.ab.ar var2, int var3, com.visustt.dicomTk.ax var4) throws UnsupportedDicomObjectException;

    public int getNumberOfBytesInStream(com.visustt.dicomTk.ab.ar ar2) {
        int n = 0;
        n = this.getValueNumberOfBytesInStream(ar2);
        try {
            if ((n & 1) > 0) {
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return n + this.getGeneralNumberOfBytesInStream(ar2);
    }

    protected int getGeneralNumberOfBytesInStream(com.visustt.dicomTk.ab.ar ar2) {
        return 4 + ar2.aa(this.specialVR) + ar2.ab(this.specialVR);
    }

    public int getEvenValueNumberOfBytesInStream(com.visustt.dicomTk.ab.ar ar2) {
        int n = this.getValueNumberOfBytesInStream(ar2);
        try {
            if ((n & 1) > 0) {
                return n + 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return n;
    }

    protected abstract int getValueNumberOfBytesInStream(com.visustt.dicomTk.ab.ar var1);

    public byte[] getByteStream(com.visustt.dicomTk.ab.ar ar2) {
        int n = this.getNumberOfBytesInStream(ar2);
        byte[] byArray = new byte[n];
        com.visustt.dicomTk.util.ak ak2 = new com.visustt.dicomTk.util.ak(byArray);
        boolean bl = false;
        int n2 = this.getValueNumberOfBytesInStream(ar2);
        if ((n2 & 1) > 0) {
            ++n2;
            bl = true;
        }
        ak2.aa(ar2.aa(this.dicomTag));
        ak2.aa(ar2.aa(this.getValueRepresentation(), this.specialVR));
        ak2.aa(ar2.aa(n2, this.specialVR));
        try {
            for (int i = 0; i < this.valueMultiplication; ++i) {
                this.write(ak2, ar2, i, bl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        ak2.ad();
        return byArray;
    }

    public void writeByteStream(com.visustt.dicomTk.ab.ar ar2, com.visustt.dicomTk.util.ak ak2) {
        boolean bl = false;
        int n = this.getValueNumberOfBytesInStream(ar2);
        if ((n & 1) > 0) {
            ++n;
            bl = true;
        }
        ak2.aa(ar2.aa(this.dicomTag));
        ak2.aa(ar2.aa(this.getValueRepresentation(), this.specialVR));
        ak2.aa(ar2.aa(n, this.specialVR));
        try {
            for (int i = 0; i < this.valueMultiplication; ++i) {
                this.write(ak2, ar2, i, bl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
    }

    protected abstract void write(com.visustt.dicomTk.util.ak var1, com.visustt.dicomTk.ab.ar var2, int var3, boolean var4);

    public byte[] getDataAsByteArray(com.visustt.dicomTk.ab.ar ar2) {
        int n = this.getValueNumberOfBytesInStream(ar2);
        try {
            if (n == 0) {
                return new byte[0];
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        boolean bl = false;
        if ((n & 1) > 0) {
            ++n;
            bl = true;
        }
        byte[] byArray = new byte[n];
        com.visustt.dicomTk.util.ak ak2 = new com.visustt.dicomTk.util.ak(byArray);
        try {
            for (int i = 0; i < this.valueMultiplication; ++i) {
                this.write(ak2, ar2, i, bl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        ak2.ad();
        return byArray;
    }

    public final void setDicomElements(DicomElementList dicomElementList) {
        this.dicomElements = dicomElementList;
    }

    public final int getValueMultiplication() {
        return this.valueMultiplication;
    }

    public final String getElementName() {
        return this.elementName;
    }

    public int getElementLength() {
        return this.lengthOfValues;
    }

    public abstract String getValueRepresentation();

    public final DicomTag getDicomTag() {
        return this.dicomTag;
    }

    public abstract void check() throws InvalidDataException;

    public void setCheckValuesEnabled(boolean bl) {
        this.checkEnabled = bl;
    }

    public boolean isCheckValuesEnabled() {
        return this.checkEnabled;
    }

    public final int compareTo(Object object) {
        try {
            if (object instanceof DicomElement) {
                return ((DicomElement)object).dicomTag.compareTo(this.dicomTag);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        try {
            if (object instanceof DicomTag) {
                return -this.dicomTag.compareTo((DicomTag)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return -1;
    }

    public final int compareTo(DicomElement dicomElement) {
        return dicomElement.dicomTag.compareTo(this.dicomTag);
    }

    public abstract String[] getValues();

    public abstract Object[] getElementValues();

    public abstract Object[] getElementObjects() throws InvalidDataException;

    public Object getElementObject() throws InvalidDataException {
        Object[] objectArray;
        block4: {
            objectArray = this.getElementObjects();
            try {
                try {
                    if (objectArray != null && objectArray.length != 0) break block4;
                }
                catch (InvalidDataException invalidDataException) {
                    throw DicomElement.b(invalidDataException);
                }
                return null;
            }
            catch (InvalidDataException invalidDataException) {
                throw DicomElement.b(invalidDataException);
            }
        }
        return objectArray[0];
    }

    public abstract void setElementObjects(Object[] var1) throws InvalidDataException, ClassCastException;

    protected void isModified() {
        this.elementName = this.elementName + " [*]";
    }

    public void setValuesToNull() {
        block10: {
            try {
                block9: {
                    try {
                        if (!(this instanceof av)) break block9;
                        if (this.valueMultiplication < 1) break block10;
                    }
                    catch (Exception exception) {
                        throw DicomElement.b(exception);
                    }
                    av av2 = (av)this;
                    int n = av2.ab();
                    if (n >= 0) {
                        for (int i = 0; i < n; ++i) {
                            DicomElementList dicomElementList = av2.ac(i);
                            try {
                                for (int j = 0; j < dicomElementList.getSize(); ++j) {
                                    dicomElementList.getDicomElementAt(j).setValuesToNull();
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                throw DicomElement.b(exception);
                            }
                        }
                    }
                    break block10;
                }
                this.setElementObjects(null);
            }
            catch (Exception exception) {
                logger.warn((Object)("Exception occurs in setValuesToNull() " + exception), exception);
            }
        }
    }

    public abstract void kill();

    public String toString() {
        return this.dicomTag.toString() + this.getValueRepresentation() + " = " + this.elementName + " [" + this.valueDump() + "]";
    }

    /*
     * Loose catch block
     */
    public Object getValuesAsObject() {
        try {
            int n;
            block35: {
                block36: {
                    n = this.getValueMultiplication();
                    if (n == 0) {
                        return null;
                    }
                    if (this.valueIsSequenceType()) {
                        Vector<DicomElementList> vector = new Vector<DicomElementList>();
                        try {
                            for (int i = 0; i < n; ++i) {
                                vector.addElement(this.getValueAsSequence(i));
                            }
                        }
                        catch (Exception exception) {
                            throw DicomElement.b(exception);
                        }
                        return vector;
                    }
                    if (this.valueIsByteArrayType()) {
                        return this.getValueAsByteArray();
                    }
                    if (this.valueIsShortArrayType()) {
                        return this.getValueAsShortArray();
                    }
                    try {
                        if (n != 1) break block35;
                        if (!this.valueIsLongType()) break block36;
                    }
                    catch (Exception exception) {
                        throw DicomElement.b(exception);
                    }
                    return this.getValueAsLong(0);
                }
                if (this.valueIsDoubleType()) {
                    return this.getValueAsDouble(0);
                }
                if (this.valueIsIntType()) {
                    return this.getValueAsInt(0);
                }
                if (this.valueIsDateType()) {
                    return this.getValueAsDate(0);
                }
                if (this.valueIsTimeType()) {
                    return this.getValueAsTime(0);
                }
                if (this instanceof aae) {
                    return new PersonName(this.getValueAsString(0));
                }
                if (this.valueIsStringType()) {
                    return this.getValueAsString(0);
                }
            }
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (true) {
                block38: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    block39: {
                                        block37: {
                                            if (n2 >= n) break;
                                            try {
                                                block44: {
                                                    if (!this.valueIsLongType()) break block37;
                                                    break block44;
                                                    catch (Exception exception) {
                                                        throw DicomElement.b(exception);
                                                    }
                                                }
                                                objectArray[n2] = this.getValueAsLong(n2);
                                                break block38;
                                            }
                                            catch (Exception exception) {
                                                throw DicomElement.b(exception);
                                            }
                                        }
                                        try {
                                            if (!this.valueIsDoubleType()) break block39;
                                            objectArray[n2] = this.getValueAsDouble(n2);
                                            break block38;
                                        }
                                        catch (Exception exception) {
                                            throw DicomElement.b(exception);
                                        }
                                    }
                                    try {
                                        if (!this.valueIsIntType()) break block40;
                                        objectArray[n2] = this.getValueAsInt(n2);
                                        break block38;
                                    }
                                    catch (Exception exception) {
                                        throw DicomElement.b(exception);
                                    }
                                }
                                try {
                                    if (!this.valueIsDateType()) break block41;
                                    objectArray[n2] = this.getValueAsDate(n2);
                                    break block38;
                                }
                                catch (Exception exception) {
                                    throw DicomElement.b(exception);
                                }
                            }
                            try {
                                if (!this.valueIsTimeType()) break block42;
                                objectArray[n2] = this.getValueAsTime(n2);
                                break block38;
                            }
                            catch (Exception exception) {
                                throw DicomElement.b(exception);
                            }
                        }
                        try {
                            if (!(this instanceof aae)) break block43;
                            objectArray[n2] = new PersonName(this.getValueAsString(n2));
                            break block38;
                        }
                        catch (Exception exception) {
                            throw DicomElement.b(exception);
                        }
                    }
                    try {
                        if (this.valueIsStringType()) {
                            objectArray[n2] = this.getValueAsString(n2);
                        }
                    }
                    catch (Exception exception) {
                        throw DicomElement.b(exception);
                    }
                }
                ++n2;
            }
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract String valueDump();

    public boolean valueIsByteArrayType() {
        block4: {
            try {
                try {
                    if (!(this instanceof ar) && !(this instanceof aw)) break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomElement.b(numberFormatException);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
        }
        return false;
    }

    public boolean valueIsShortArrayType() {
        try {
            if (this instanceof au) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return false;
    }

    public boolean valueIsIntType() {
        block11: {
            try {
                block10: {
                    try {
                        try {
                            try {
                                try {
                                    if (this instanceof aj || this instanceof am) break block10;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw DicomElement.b(numberFormatException);
                                }
                                if (this instanceof ak) break block10;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw DicomElement.b(numberFormatException);
                            }
                            if (this instanceof aao) break block10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw DicomElement.b(numberFormatException);
                        }
                        if (!(this instanceof al)) break block11;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw DicomElement.b(numberFormatException);
                    }
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
        }
        return false;
    }

    public boolean valueIsLongType() {
        block4: {
            try {
                try {
                    if (!(this instanceof ap) && !(this instanceof am)) break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomElement.b(numberFormatException);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
        }
        return false;
    }

    public boolean valueIsDoubleType() {
        block7: {
            try {
                block6: {
                    try {
                        try {
                            if (this instanceof aan || this instanceof an) break block6;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw DicomElement.b(numberFormatException);
                        }
                        if (!(this instanceof ao)) break block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw DicomElement.b(numberFormatException);
                    }
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
        }
        return false;
    }

    public boolean valueIsStringType() {
        return this instanceof ax;
    }

    public boolean valueIsDateType() {
        try {
            if (this instanceof az) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return false;
    }

    public boolean valueIsTimeType() {
        try {
            if (this instanceof aaa) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return false;
    }

    public boolean valueIsSequenceType() {
        try {
            if (this instanceof av) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return false;
    }

    public byte[] getValueAsByteArray() {
        return null;
    }

    public short[] getValueAsShortArray() {
        try {
            if (this instanceof au) {
                return ((au)this).ab();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getValueAsInt(int n) throws InvalidDataException {
        try {
            if (this instanceof aj) {
                return ((aj)this).ab(n);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomElement.b(invalidDataException);
        }
        try {
            if (this instanceof al) {
                return ((al)this).ab(n);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomElement.b(invalidDataException);
        }
        try {
            if (this instanceof ak) {
                return ((ak)this).ab(n);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomElement.b(invalidDataException);
        }
        try {
            if (this instanceof aao) {
                return ((aao)this).ac(n);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomElement.b(invalidDataException);
        }
        try {
            if (this instanceof au) {
                return ((au)this).ab()[n];
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomElement.b(invalidDataException);
        }
        throw new InvalidDataException("No VR with integer value found in DICOM tag " + this.getDicomTag() + " '" + this.getElementName() + "'");
    }

    public long getValueAsLong(int n) throws NoValidValueIndexException {
        try {
            if (this instanceof am) {
                return ((am)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ap) {
                return ((ap)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return -1L;
    }

    public double getValueAsDouble() throws NoValidValueIndexException {
        try {
            if (this instanceof am) {
                return ((am)this).ab(0);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ap) {
                return ((ap)this).ab(0);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof aj) {
                return ((aj)this).ab(0);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof al) {
                return ((al)this).ab(0);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ak) {
                return ((ak)this).ab(0);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof aao) {
                return ((aao)this).ac(0);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return this.getValueAsDouble(0);
    }

    public String getValueAsScaledDouble(int n, double d, int n2) throws NoValidValueIndexException {
        double d2 = Double.NaN;
        try {
            if (n < 0) {
                throw new NoValidValueIndexException("Index " + n + " is not valid.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        if (this instanceof an) {
            d2 = ((an)this).ab(n);
        } else if (this instanceof ao) {
            d2 = ((ao)this).ab(n);
        } else if (this instanceof aan) {
            d2 = Double.parseDouble(((aan)this).aa(n));
        } else if (this instanceof aao) {
            d2 = Double.parseDouble(((aao)this).aa(n));
        } else if (this instanceof al) {
            d2 = ((al)this).ab(n);
        } else if (this instanceof ak) {
            d2 = ((ak)this).ab(n);
        } else if (this instanceof aac) {
            try {
                d2 = Double.parseDouble(((aac)this).aa(n));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this instanceof aad) {
            try {
                d2 = Double.parseDouble(((aad)this).aa(n));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this instanceof at) {
            d2 = ((at)this).ab(n);
        } else if (this instanceof as) {
            d2 = ((as)this).ab(n);
        } else if (this instanceof aaf) {
            try {
                d2 = Double.parseDouble(((aaf)this).aa(n));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this instanceof aag) {
            try {
                d2 = Double.parseDouble(((aag)this).aa(n));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this instanceof ap) {
            d2 = ((ap)this).ab(n);
        }
        try {
            if (Double.isNaN(d2)) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        d2 *= d;
        if (n2 > 0) {
            Object object = "###0.";
            for (int i = 0; i < n2; ++i) {
                object = (String)object + "#";
            }
            DecimalFormat decimalFormat = new DecimalFormat((String)object);
            return decimalFormat.format((Object)d2);
        }
        if (n2 == 0) {
            d2 = (int)d2;
        }
        try {
            if (d2 == (double)((int)d2)) {
                return Integer.toString((int)d2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return Double.toString(d2);
    }

    public double getValueAsDouble(int n) throws NoValidValueIndexException {
        try {
            if (this instanceof an) {
                return ((an)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ao) {
                return ((ao)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof aan) {
                return Double.parseDouble(((aan)this).aa(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof aao) {
                return Double.parseDouble(((aao)this).aa(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return Double.NaN;
    }

    public double getValueAsFloat(int n) throws NoValidValueIndexException {
        try {
            if (this instanceof an) {
                return (float)((an)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ao) {
                return ((ao)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof aan) {
                return Float.parseFloat(((aan)this).aa(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return Double.NaN;
    }

    public String getValueAsString(int n) throws NoValidValueIndexException {
        try {
            if (this instanceof ax) {
                return ((ax)this).aa(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ai) {
                return Long.toString(((ai)this).ab(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ap) {
                return Long.toString(((ap)this).ab(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof ao) {
                return Float.toString(((ao)this).ab(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof an) {
                return Double.toString(((an)this).ab(n));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        try {
            if (this instanceof aw) {
                return ((aw)this).ab();
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return null;
    }

    public Date getValueAsDate(int n) throws NoValidValueIndexException, InvalidValueIndexException, InvalidDataException {
        try {
            if (this instanceof ay) {
                return ((ay)this).ab(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getValueAsTime(int n) throws NoValidValueIndexException {
        int n2;
        StringBuilder stringBuilder;
        block18: {
            if (!(this instanceof aaa)) return null;
            stringBuilder = new StringBuilder(13).append(((aaa)this).aa(n));
            try {
                if (n2 == 2) {
                    return stringBuilder + ":00:00.000000";
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw DicomElement.b(noValidValueIndexException);
            }
            try {
                if (n2 == 4) {
                    return stringBuilder.insert(2, ":").append(":00.000000").toString();
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw DicomElement.b(noValidValueIndexException);
            }
            try {
                if (n2 == 6) {
                    return stringBuilder.insert(4, ":").insert(2, ":").append(".000000").toString();
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw DicomElement.b(noValidValueIndexException);
            }
            try {
                try {
                    try {
                        if (n2 <= 7 || n2 >= 13) break block18;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw DicomElement.b(noValidValueIndexException);
                    }
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw DicomElement.b(noValidValueIndexException);
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw DicomElement.b(noValidValueIndexException);
            }
            for (n2 = stringBuilder.length(); n2 < 13; ++n2) {
                stringBuilder.append("0");
            }
        }
        try {
            if (n2 == 13) return stringBuilder.insert(4, ":").insert(2, ":").toString();
            return null;
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
    }

    public DicomElementList getValueAsSequence(int n) throws NoValidValueIndexException {
        try {
            if (this instanceof av) {
                return ((av)this).aa(n);
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw DicomElement.b(noValidValueIndexException);
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.warn((Object)("Exception occurs in clone() " + cloneNotSupportedException), cloneNotSupportedException);
            return null;
        }
    }

    public final DicomElement cloneAndSetDicomElementList(DicomElementList dicomElementList) {
        DicomElement dicomElement = (DicomElement)this.clone();
        dicomElement.setDicomElements(dicomElementList);
        return dicomElement;
    }

    public abstract boolean canUseWildcardMatching();

    public boolean isValid() {
        return this._isValid;
    }

    public static DicomElement create(DicomTag dicomTag) {
        ElementInformation elementInformation = DicomDictionary.instance().searchElement(dicomTag);
        try {
            if (elementInformation == null) {
                return new aw(dicomTag);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DicomElement.b(numberFormatException);
        }
        return elementInformation.createElement();
    }

    public int readLength(com.visustt.dicomTk.util.ai ai2, com.visustt.dicomTk.ab.ar ar2) throws UnsupportedDicomObjectException {
        try {
            int n = ar2.aa(ai2);
            return n;
        }
        catch (UnsupportedDicomObjectException unsupportedDicomObjectException) {
            throw new UnsupportedDicomObjectException("Illegal length field on DICOM element " + this, unsupportedDicomObjectException);
        }
    }

    public static final DicomElement createDicomElement(byte[] byArray, com.visustt.dicomTk.ab.ar ar2, DicomElementList dicomElementList) throws NoValidDicomObjectException, UnsupportedDicomObjectException, CommonDicomException {
        com.visustt.dicomTk.ax ax2 = new com.visustt.dicomTk.ax();
        com.visustt.dicomTk.util.ai ai2 = new com.visustt.dicomTk.util.ai(byArray);
        try {
            DicomElement dicomElement;
            if (ai2.ac() && (dicomElement = ar2.ab(ai2, dicomElementList, ax2)).isValid()) {
                return dicomElement;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NoValidDicomObjectException("Can't decode data.", nullPointerException);
        }
        return null;
    }

    public boolean isPrivate() {
        boolean bl;
        block9: {
            block8: {
                int n = this.getDicomTag().getGroupNumber();
                int n2 = this.getDicomTag().getElementNumber();
                try {
                    try {
                        try {
                            try {
                                if (n % 2 == 0 || n2 <= 16) break block8;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw DicomElement.b(numberFormatException);
                            }
                            if (n < 9) break block8;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw DicomElement.b(numberFormatException);
                        }
                        if (n == 65535) break block8;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw DicomElement.b(numberFormatException);
                    }
                    bl = true;
                    break block9;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomElement.b(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public boolean isPrivateCreator() {
        boolean bl;
        block5: {
            block4: {
                int n = this.getDicomTag().getGroupNumber();
                int n2 = this.getDicomTag().getElementNumber();
                try {
                    try {
                        if (n % 2 == 0 || n2 != 16) break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw DicomElement.b(numberFormatException);
                    }
                    bl = true;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomElement.b(numberFormatException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public final int hashCode() {
        return new ag().aa((Object)this.getDicomTag()).aa((Object)this.getValueRepresentation()).aa(this.getElementLength()).aa(this.getValuesAsObject()).aa();
    }

    public final boolean equals(Object object) {
        Object object2;
        Object object3;
        block25: {
            try {
                if (object == null) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
            try {
                if (this.getClass() != object.getClass()) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
            DicomElement dicomElement = (DicomElement)object;
            try {
                if (!Objects.equals(this.getDicomTag(), dicomElement.getDicomTag())) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
            try {
                if (!Objects.equals(this.getValueRepresentation(), dicomElement.getValueRepresentation())) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
            try {
                if (this instanceof ax) {
                    return Objects.deepEquals(this.getValues(), dicomElement.getValues());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
            try {
                if (this.getElementLength() != dicomElement.getElementLength()) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
            object3 = this.getValuesAsObject();
            object2 = dicomElement.getValuesAsObject();
            try {
                block24: {
                    try {
                        try {
                            if (object3 instanceof Object[] || object3 instanceof byte[]) break block24;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw DicomElement.b(numberFormatException);
                        }
                        if (!(object3 instanceof short[])) break block25;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw DicomElement.b(numberFormatException);
                    }
                }
                return Objects.deepEquals(object3, object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw DicomElement.b(numberFormatException);
            }
        }
        return Objects.equals(object3, object2);
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

