/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.PersonName;
import com.visustt.dicomTk.af.ak;
import com.visustt.dicomTk.data.aaa;
import com.visustt.dicomTk.data.aac;
import com.visustt.dicomTk.data.aae;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.aao;
import com.visustt.dicomTk.data.aap;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.az;
import java.util.Date;
import java.util.Vector;

public class SeriesModule
extends DicomModule {
    private String modality = null;
    private String seriesDescription = null;
    private ak derivationImageSequence;
    private static final Vector<DicomTag> tagList = new Vector();

    public SeriesModule(DicomElementList dicomElementList) {
        super(dicomElementList);
    }

    public SeriesModule(DicomModule dicomModule) {
        super(dicomModule);
    }

    public String getModality() {
        if (this.modality == null) {
            this.modality = this.getString(BaseDicomTagNames.TAG_modality);
        }
        return this.modality;
    }

    public void setModality(String string) throws InvalidDataException {
        this.modality = string;
        this.insertDicomElement(new aam(BaseDicomTagNames.TAG_modality, string));
    }

    public void setLaterality(String string) throws InvalidDataException {
        this.insertDicomElement(new aam(BaseDicomTagNames.TAG_laterality, string));
    }

    public String getSeriesDate() {
        return this.getString(BaseDicomTagNames.TAG_seriesDate);
    }

    public Date getSeriesDateAsDate() {
        return this.getDate(BaseDicomTagNames.TAG_seriesDate);
    }

    public void setSeriesDate(String string) throws InvalidDataException {
        this.insertDicomElement(new az(BaseDicomTagNames.TAG_seriesDate, string));
    }

    public void setSeriesDate(Date date) throws InvalidDataException {
        this.insertDicomElement(new az(BaseDicomTagNames.TAG_seriesDate, date));
    }

    public String getSeriesTime() {
        return this.getString(BaseDicomTagNames.TAG_seriesTime);
    }

    public Date getSeriesTimeAsDate() {
        return this.getDate(BaseDicomTagNames.TAG_seriesTime);
    }

    public void setSeriesTime(String string) throws InvalidDataException {
        this.insertDicomElement(new aaa(BaseDicomTagNames.TAG_seriesTime, string));
    }

    public void setSeriesTime(Date date) throws InvalidDataException {
        this.insertDicomElement(new aaa(BaseDicomTagNames.TAG_seriesTime, date));
    }

    public String getSeriesInstanceUID() {
        return this.getString(BaseDicomTagNames.TAG_seriesInstanceUID);
    }

    public void setSeriesInstanceUID(String string) throws InvalidDataException {
        this.insertDicomElement(new aap(BaseDicomTagNames.TAG_seriesInstanceUID, string));
    }

    public Integer getSeriesNumberAsInteger() {
        return this.getInteger(BaseDicomTagNames.TAG_seriesNumber);
    }

    public int getSeriesNumber() {
        try {
            return this.getInt(BaseDicomTagNames.TAG_seriesNumber);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setSeriesNumber(int n) throws InvalidDataException {
        this.insertDicomElement(new aao(BaseDicomTagNames.TAG_seriesNumber, n));
    }

    public String getSeriesDescription() {
        if (this.seriesDescription == null) {
            this.seriesDescription = this.getString(BaseDicomTagNames.TAG_seriesDescription);
        }
        return this.seriesDescription;
    }

    public void setSeriesDescription(String string) throws InvalidDataException {
        this.seriesDescription = string;
        this.insertDicomElement(new aac(BaseDicomTagNames.TAG_seriesDescription, string));
    }

    public ak getDerivationImageSequence() throws InvalidDataException {
        try {
            if (this.derivationImageSequence == null) {
                this.derivationImageSequence = this.createDicomModuleList(BaseDicomTagNames.TAG_derivationImageSequence);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw SeriesModule.a(invalidDataException);
        }
        return this.derivationImageSequence;
    }

    public boolean checkForModality(String string) {
        String string2 = this.getModality();
        if (string2 != null && string != null) {
            return string2.equals(string);
        }
        return false;
    }

    public void createDefaultModule(String string, String string2) throws InvalidDataException {
        this.setModality(string);
        this.setSeriesInstanceUID(string2);
        this.setSeriesNumber(1);
        this.insertDicomElement(new aam(DicomTagNames.TAG_patientOrientation, new String[]{""}));
        av av2 = new av(BaseDicomTagNames.TAG_referencedPerformedProcedureStepSequence);
        this.insertDicomElement(av2);
    }

    public boolean isValid() throws InvalidDataException {
        boolean bl;
        block11: {
            block10: {
                try {
                    try {
                        try {
                            try {
                                try {
                                    if (!this.contents.hasDicomElement(BaseDicomTagNames.TAG_modality) || "".equals(this.getModality())) break block10;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw SeriesModule.a(invalidDataException);
                                }
                                if (!this.contents.hasDicomElement(BaseDicomTagNames.TAG_seriesInstanceUID)) break block10;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw SeriesModule.a(invalidDataException);
                            }
                            if ("".equals(this.getSeriesInstanceUID())) break block10;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw SeriesModule.a(invalidDataException);
                        }
                        if (!this.contents.hasDicomElement(BaseDicomTagNames.TAG_seriesNumber)) break block10;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw SeriesModule.a(invalidDataException);
                    }
                    bl = true;
                    break block11;
                }
                catch (InvalidDataException invalidDataException) {
                    throw SeriesModule.a(invalidDataException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public PersonName getPerformingPhysiciansName() {
        return this.getPersonName(BaseDicomTagNames.TAG_performingPhysicianName);
    }

    public void setPerformingPhysiciansName(PersonName personName) throws InvalidDataException {
        String string = null;
        if (personName != null) {
            string = personName.getDICOMString();
        }
        this.insertDicomElement(new aae(BaseDicomTagNames.TAG_performingPhysicianName, string));
    }

    public void setPerformingPhysiciansName(String string) throws InvalidDataException {
        this.insertDicomElement(new aae(BaseDicomTagNames.TAG_performingPhysicianName, string));
    }

    public SeriesModule getCopy() {
        return new SeriesModule(DicomElementList.getCopy(this.getDicomElementList(), tagList));
    }

    static {
        tagList.add(BaseDicomTagNames.TAG_modality);
        tagList.add(BaseDicomTagNames.TAG_seriesInstanceUID);
        tagList.add(BaseDicomTagNames.TAG_seriesNumber);
        tagList.add(BaseDicomTagNames.TAG_laterality);
        tagList.add(BaseDicomTagNames.TAG_seriesDate);
        tagList.add(BaseDicomTagNames.TAG_seriesTime);
        tagList.add(BaseDicomTagNames.TAG_performingPhysicianName);
        tagList.add(BaseDicomTagNames.TAG_protocolName);
        tagList.add(BaseDicomTagNames.TAG_seriesDescription);
        tagList.add(BaseDicomTagNames.TAG_operatorsName);
        tagList.add(BaseDicomTagNames.TAG_referencedPerformedProcedureStepSequence);
        tagList.add(BaseDicomTagNames.TAG_bodyPartExamined);
        tagList.add(BaseDicomTagNames.TAG_patientPosition);
        tagList.add(BaseDicomTagNames.TAG_requestAttributesSequence);
    }

    private static InvalidDataException a(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

