/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk;

import com.visustt.dicomTk.util.aq;
import java.io.Serializable;

public final class DicomTag
implements Comparable<DicomTag>,
Serializable {
    static final long serialVersionUID = -5399392163214073705L;
    private long tagNumber;

    public DicomTag() {
        this.setTagNumber(0L);
    }

    public DicomTag(long l) {
        this.setTagNumber(l);
    }

    public DicomTag(int n, int n2) {
        this.setTagNumber(n, n2);
    }

    public DicomTag(String string) {
        this.setTagNumber(string);
    }

    public final void setTagNumber(long l) {
        this.tagNumber = l & 0xFFFFFFFFL;
    }

    public final void setTagNumber(int n, int n2) {
        try {
            if (n < 0) {
                throw new IllegalArgumentException("Group number is negative.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        try {
            if (n2 < 0) {
                throw new IllegalArgumentException("Element number is negative.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        this.tagNumber = (long)(n & 0xFFFF) << 16 | (long)(n2 & 0xFFFF);
    }

    public final void setTagNumber(String string) throws NumberFormatException {
        int n;
        int n2;
        block14: {
            block13: {
                try {
                    if (string == null) {
                        throw new IllegalArgumentException("DICOM tag string is null.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomTag.a(numberFormatException);
                }
                try {
                    try {
                        if (string.length() <= 0 || string.charAt(0) != '(') break block13;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw DicomTag.a(numberFormatException);
                    }
                    if (string.charAt(string.length() - 1) != ')') break block13;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomTag.a(numberFormatException);
                }
                int n3 = string.indexOf(44, 1);
                n2 = Integer.parseInt(string.substring(1, n3).trim(), 16);
                try {
                    if (n2 > 65535) {
                        throw new NumberFormatException(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomTag.a(numberFormatException);
                }
                n = Integer.parseInt(string.substring(n3 + 1, string.length() - 1).trim(), 16);
                try {
                    if (n > 65535) {
                        throw new NumberFormatException(string);
                    }
                    break block14;
                }
                catch (NumberFormatException numberFormatException) {
                    throw DicomTag.a(numberFormatException);
                }
            }
            throw new NumberFormatException(string);
        }
        this.setTagNumber(n2, n);
    }

    public final long getTagNumber() {
        return this.tagNumber;
    }

    public final int getGroupNumber() {
        return (int)(this.tagNumber >>> 16);
    }

    public final int getElementNumber() {
        return (int)(this.tagNumber & 0xFFFFL);
    }

    public final boolean equals(long l) {
        boolean bl;
        try {
            bl = this.tagNumber == l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        return bl;
    }

    public final boolean equals(DicomTag dicomTag) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (dicomTag == null || dicomTag.getTagNumber() != this.tagNumber) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DicomTag.a(illegalArgumentException);
                    }
                    bl = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomTag.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public final boolean equals(Object object) {
        boolean bl;
        try {
            if (!(object instanceof DicomTag)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        try {
            bl = this.tagNumber == ((DicomTag)object).tagNumber;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        return bl;
    }

    @Override
    public final int compareTo(DicomTag dicomTag) {
        try {
            if (this.tagNumber < dicomTag.tagNumber) {
                return -1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        try {
            if (this.tagNumber > dicomTag.tagNumber) {
                return 1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        return 0;
    }

    public String toString() {
        return "(" + aq.ag(this.getGroupNumber()) + "," + aq.ag(this.getElementNumber()) + ")";
    }

    public final int hashCode() {
        return (int)this.tagNumber;
    }

    public final boolean isPixelData() {
        boolean bl;
        try {
            bl = this.tagNumber == 2145386512L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        return bl;
    }

    public boolean isOverlayData() {
        long l = this.tagNumber & 0xFFFFFFFFFF00FFFFL;
        try {
            if (l == 0x60003000L) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        return false;
    }

    public boolean isPrivateElement() {
        boolean bl;
        block11: {
            block10: {
                int n = this.getGroupNumber();
                try {
                    try {
                        try {
                            try {
                                try {
                                    if (n == 1 || n == 3) break block10;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DicomTag.a(illegalArgumentException);
                                }
                                if (n == 5) break block10;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DicomTag.a(illegalArgumentException);
                            }
                            if (n == 7) break block10;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DicomTag.a(illegalArgumentException);
                        }
                        if ((n & 1) != 1) break block10;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DicomTag.a(illegalArgumentException);
                    }
                    bl = true;
                    break block11;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomTag.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public boolean isInItemGroup() {
        boolean bl;
        try {
            bl = this.getGroupNumber() == 65534;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomTag.a(illegalArgumentException);
        }
        return bl;
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

